<?php
// Path ke config disesuaikan
require_once '../config.php';

// GATEKEEPER: Proteksi halaman, hanya admin yang bisa akses
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || $_SESSION['is_admin'] !== true) {
    header("Location: /admin/login");
    exit();
}

// Ambil nama admin yang sedang login dari session
$admin_username = $_SESSION['username'];

// === AMBIL DATA STATISTIK UNTUK ADMIN ===
// 1. Total Pengguna
$result_total_users = $conn->query("SELECT COUNT(id) as total FROM users");
$total_users = $result_total_users->fetch_assoc()['total'];

// 2. Total limit_api Semua Pengguna
$result_total_limit_api = $conn->query("SELECT SUM(limit_api) as total FROM users");
$total_limit_api = $result_total_limit_api->fetch_assoc()['total'];

// 3. Jumlah Admin
$result_total_admins = $conn->query("SELECT COUNT(id) as total FROM users WHERE role = 'admin'");
$total_admins = $result_total_admins->fetch_assoc()['total'];



$conn->close();
// Variabel untuk judul halaman
$page_title = "Admin";

// Memanggil file header
require_once 'menu/header.php';
?>
    <div class="container">
        <main>
            <div class="info-grid">
                <div class="card">
                    <p class="label">Total Pengguna</p>
                    <p class="value"><?php echo $total_users; ?></p>
                </div>
                <div class="card">
                    <p class="label">Total Admin</p>
                    <p class="value"><?php echo $total_admins; ?></p>
                </div>
                <div class="card">
                    <p class="label">Total limit_api Pengguna</p>
                    <p class="value">Rp <?php echo number_format($total_limit_api ?? 0, 0, ',', '.'); ?></p>
                </div>
            </div>

            <div class="card" style="margin-top: 2rem;">
                <h2>Aktivitas Terkini</h2>
                <p>Fitur untuk menampilkan log aktivitas atau transaksi akan muncul di sini.</p>
            </div>
        </main>
    </div>

<?php
// Memanggil file footer
require_once 'menu/footer.php';
?>