<?php
// Memulai sesi dan memanggil file konfigurasi
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once '../config.php';

// Proteksi halaman: hanya admin yang bisa akses
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || $_SESSION['is_admin'] !== true) {
    header("Location: /admin/login");
    exit();
}

// ==========================================================
// --- LOGIKA SINKRONISASI JIKA TOMBOL DIKLIK ---
// ==========================================================
if (isset($_GET['action']) && $_GET['action'] == 'sync') {
    // Ambil Konfigurasi Provider dari Database
    $stmt_gw = $conn->prepare("SELECT url, apikey FROM payment_setting WHERE nama = 'atlantich2h'");
    $stmt_gw->execute();
    $provider_config = $stmt_gw->get_result()->fetch_assoc();
    $stmt_gw->close();

    if ($provider_config) {
        $target_url = rtrim($provider_config['url'], '/') . '/layanan/price_list';
        $provider_apikey = $provider_config['apikey'];
        $all_products = [];
        $has_error = false;

        // Lakukan panggilan untuk setiap tipe (prabayar & pascabayar)
        $types_to_fetch = ['prabayar', 'pascabayar'];

        foreach ($types_to_fetch as $type) {
            $post_data = http_build_query([
                'api_key' => $provider_apikey,
                'type' => $type
            ]);

            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $target_url,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $post_data,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/x-www-form-urlencoded' // Header Sesuai Permintaan
                ],
                CURLOPT_TIMEOUT => 60
            ]);
            $response_body = curl_exec($ch);
            curl_close($ch);
            $decoded_response = json_decode($response_body, true);

            if (isset($decoded_response['status']) && $decoded_response['status'] == true && is_array($decoded_response['data'])) {
                // Gabungkan hasil dari kedua panggilan
                $all_products = array_merge($all_products, $decoded_response['data']);
            } else {
                $has_error = true;
                $_SESSION['error_message'] = "Gagal mengambil data untuk tipe: " . $type . ". Provider tidak memberikan data yang valid.";
                break; // Hentikan jika salah satu panggilan gagal
            }
        }

        if (!$has_error && !empty($all_products)) {
            // Lanjutkan proses simpan ke database jika tidak ada error
            $sql_upsert = "INSERT INTO produk_harga (kode_produk, nama_produk, kategori, tipe, provider, harga, catatan, status, img_url)
                           VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
                           ON DUPLICATE KEY UPDATE
                           nama_produk = VALUES(nama_produk), harga = VALUES(harga), status = VALUES(status), img_url = VALUES(img_url)";
            
            $stmt_upsert = $conn->prepare($sql_upsert);
            $berhasil = 0;

            foreach ($all_products as $product) {
                $stmt_upsert->bind_param("sssssisss",
                    $product['code'], $product['name'], $product['category'],
                    $product['type'], $product['provider'], $product['price'],
                    $product['note'], $product['status'], $product['img_url']
                );
                if($stmt_upsert->execute()){
                    $berhasil++;
                }
            }
            $stmt_upsert->close();
            $_SESSION['success_message'] = "Sinkronisasi selesai. " . $berhasil . " produk berhasil diperbarui/ditambahkan.";
        }
    } else {
        $_SESSION['error_message'] = "Konfigurasi provider 'atlantich2h' tidak ditemukan.";
    }
    header("Location: list_harga.php");
    exit();
}

// Mengambil semua data produk dari database untuk ditampilkan
$products = [];
$sql = "SELECT * FROM produk_harga ORDER BY kategori, provider, harga ASC";
$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $products[] = $row;
    }
}

$page_title = "Daftar Harga Produk";
require_once 'menu/header.php';
?>
<style>
  /* Gaya untuk ikon produk di tabel */
.product-icon {
    width: 40px;
    height: 40px;
    object-fit: cover;
    border-radius: 8px;
    border: 1px solid var(--border-color);
}

/* Badge Status */
.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 700;
    text-transform: capitalize;
}
.status-available {
    background-color: #D1FAE5; /* Warna Hijau */
    color: #065F46;
}
.status-unavailable {
    background-color: #FEE2E2; /* Warna Merah */
    color: #991B1B;
}

</style>
<div class="container">
    <main>
        <div class="page-header">
            <h1>Daftar Harga Produk</h1>
            <a href="?action=sync" class="btn btn-primary" onclick="return confirm('Proses ini akan mengambil data Prabayar & Pascabayar dari provider dan mungkin membutuhkan waktu. Lanjutkan?')">
                🔄 Sinkronisasi Harga
            </a>
        </div>
        
        <?php
        if (isset($_SESSION['success_message'])) {
            echo '<div class="alert alert-success">' . htmlspecialchars($_SESSION['success_message']) . '</div>';
            unset($_SESSION['success_message']);
        }
        if (isset($_SESSION['error_message'])) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($_SESSION['error_message']) . '</div>';
            unset($_SESSION['error_message']);
        }
        ?>

        <div class="card">
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Gambar</th>
                            <th>Kode</th>
                            <th>Nama Produk</th>
                            <th>Kategori</th>
                            <th>Provider</th>
                            <th>Harga</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($products)): ?>
                            <tr>
                                <td colspan="8" style="text-align: center; padding: 2rem;">
                                    Belum ada data produk. Silakan lakukan sinkronisasi.
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($products as $product): ?>
                                <tr>
                                    <td>
                                        <img src="<?php echo htmlspecialchars($product['img_url']); ?>" alt="ikon" class="product-icon">
                                    </td>
                                    <td><strong><?php echo htmlspecialchars($product['kode_produk']); ?></strong></td>
                                    <td><?php echo htmlspecialchars($product['nama_produk']); ?></td>
                                    <td><?php echo htmlspecialchars($product['kategori']); ?></td>
                                    <td><?php echo htmlspecialchars($product['provider']); ?></td>
                                    <td>Rp <?php echo number_format($product['harga'], 0, ',', '.'); ?></td>
                                    <td>
                                        <span class="status-badge status-<?php echo strtolower(htmlspecialchars($product['status'])); ?>">
                                            <?php echo htmlspecialchars($product['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn-sm btn-warning">Edit</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>

<?php
$conn->close();
require_once 'menu/footer.php';
?>
