<?php
// Memulai sesi dan memanggil file konfigurasi
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once '../config.php';

// Proteksi halaman: hanya admin yang bisa akses
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || $_SESSION['is_admin'] !== true) {
    header("Location: /admin/login");
    exit();
}

// Mengambil semua data pengguna dari database, KECUALI password
$users = [];
$sql = "SELECT * FROM users ORDER BY id DESC";
$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
}

// Fungsi helper untuk format tanggal
function format_tanggal($datetime) {
    if (empty($datetime)) return "-";
    return date("d M Y, H:i", strtotime($datetime));
}

$page_title = "Daftar Pengguna";
require_once 'menu/header.php'; // Panggil header admin Anda
?>

<div class="container">
    <main>
        <div class="page-header">
            <h1>Manajemen Pengguna</h1>
            </div>

        <div class="card">
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Username</th>
                            <th>Sisa Limit</th>
                            <th>API Key</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($users)): ?>
                            <tr>
                                <td colspan="8" style="text-align: center; padding: 2rem;">
                                    Belum ada data pengguna.
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?php echo $user['id']; ?></td>
                                    <td><strong><?php echo htmlspecialchars($user['username']); ?></strong></td>
                                    <td><?php echo ($user['limit_api'] == 0) ? '0' : number_format($user['limit_api']); ?></td>
                                    <td><?php echo htmlspecialchars($user['apikey']); ?></td>
                                    <td>
                                        <a href="edit_user.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>

<?php
$conn->close();
require_once 'menu/footer.php'; // Panggil footer admin Anda
?>
