<?php
// Path ke config disesuaikan karena berada di dalam subfolder
require_once '../config.php';

$error_message = '';

// Jika sudah login sebagai admin, langsung ke dashboard admin
if (isset($_SESSION['is_admin']) && $_SESSION['is_admin'] === true) {
    header("Location: /admin/");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $conn->real_escape_string(trim($_POST['username']));
    $password = $conn->real_escape_string(trim($_POST['password']));

    // Ambil data user termasuk role
    $stmt = $conn->prepare("SELECT id, username, password, role FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();
        
        // Verifikasi password DAN cek role
        if (password_verify($password, $user['password'])) {
            // ## KONDISI PENTING: CEK APAKAH ROLE ADALAH 'ADMIN' ##
            if ($user['role'] == 'admin') {
                // Login berhasil, buat session admin
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['is_admin'] = true; // Penanda khusus admin
                
                header("Location: /admin"); // Redirect ke dashboard admin
                exit();
            } else {
                // Password benar, tapi bukan admin
                $error_message = "Akses ditolak. Anda bukan admin.";
            }
        } else {
            // Password salah
            $error_message = "Username atau password salah.";
        }
    } else {
        // Username tidak ditemukan
        $error_message = "Username atau password salah.";
    }
    $stmt->close();
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>
    <style>
      body { display: flex; justify-content: center; align-items: center; height: 100vh; font-family: sans-serif; background-color: #343a40; }
      .container { width: 350px; padding: 2rem; background: #fff; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
      h2 { margin-bottom: 1.5rem; text-align: center; color: #343a40; }
      .form-group { margin-bottom: 1rem; }
      label { display: block; margin-bottom: 0.5rem; }
      input { width: 100%; padding: 0.5rem; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box;}
      button { width: 100%; padding: 0.7rem; color: #fff; background-color: #0d6efd; border: none; border-radius: 4px; cursor: pointer; font-weight: bold; }
      .message { margin-top: 1rem; padding: 0.7rem; border-radius: 4px; text-align: center; background-color: #f8d7da; color: #721c24; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Admin Panel Login</h2>
        <?php if ($error_message): ?>
            <div class="message"><?php echo $error_message; ?></div>
        <?php endif; ?>
        <form action="login" method="post">
            <div class="form-group">
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
