    <script src="/assets/script.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const generateBtn = document.getElementById('generateBtn');
        const codeInput = document.getElementById('kode_voucher');
    
        generateBtn.addEventListener('click', function() {
            // Panggil fungsi untuk membuat kode acak
            const newCode = generateVoucherCode(6);
            // Masukkan kode baru ke dalam input field
            codeInput.value = newCode;
        });
    
        /**
         * Fungsi untuk membuat kode voucher acak dengan format XXXX-XXXX-XXXX
         * @param {number} length - Panjang total kode yang diinginkan (harus kelipatan 4).
         * @returns {string} Kode voucher acak.
         */
        function generateVoucherCode(length) {
            const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            let result = '';
            for (let i = 0; i < length; i++) {
                // Tambahkan tanda hubung (-) setiap 4 karakter
                if (i > 0 && i % 4 === 0) {
                    result += '';
                }
                result += chars.charAt(Math.floor(Math.random() * chars.length));
            }
            return result;
        }
    });
    </script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const jenisSelect = document.getElementById('jenis');
    const inputSaldoTetap = document.getElementById('input-saldo-tetap');
    const inputSaldoRandom = document.getElementById('input-saldo-random');
    const inputJumlahMin = document.querySelector('input[name="jumlah_min"]');
    const inputJumlahMinRandom = document.querySelector('input[name="jumlah_min_random"]');
    const inputJumlahMax = document.querySelector('input[name="jumlah_max"]');

    function toggleInputs() {
        if (jenisSelect.value === 'saldo_random') {
            inputSaldoTetap.style.display = 'none';
            inputSaldoRandom.style.display = 'block';
            // Pindahkan nilai dari input random ke input utama yang akan disubmit
            inputJumlahMin.value = inputJumlahMinRandom.value; 
        } else {
            inputSaldoTetap.style.display = 'block';
            inputSaldoRandom.style.display = 'none';
            inputJumlahMax.value = ''; // Kosongkan max jika bukan random
        }
    }
    
    // Sinkronkan nilai input min saat berganti
    inputJumlahMinRandom.addEventListener('input', () => { inputJumlahMin.value = inputJumlahMinRandom.value; });

    jenisSelect.addEventListener('change', toggleInputs);
    toggleInputs(); // Panggil saat halaman dimuat
});
</script>
</body>
</html>
