<?php
header("Access-Control-Allow-Origin: *"); 
header('Content-Type: application/json');

require_once '../config.php';

function send_response($status_code, $data) {
    global $conn;
    if ($conn) {
        $conn->close();
    }
    http_response_code($status_code);
    echo json_encode($data);
    exit;
}

// 1. Validasi Metode & Parameter
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    send_response(405, ['status' => false, 'message' => 'Method Not Allowed. Use GET.']);
}

$user_apikey = isset($_GET['apikey']) ? trim($_GET['apikey']) : null;
$bank_code = isset($_GET['bank_code']) ? trim($_GET['bank_code']) : null;
$account_number = isset($_GET['account_number']) ? trim($_GET['account_number']) : null;

if (empty($user_apikey) || empty($bank_code) || empty($account_number)) {
    send_response(400, [
        'status' => false,
        'message' => 'Bad Request. All parameters are required: apikey, bank_code, account_number.'
    ]);
}

// 2. Otentikasi API Key & Cek Limit
$db_user_id = null;
$limit_api = null;
$hit_hari_ini = null;

$stmt = $conn->prepare("SELECT id, limit_api, hit_hari_ini FROM users WHERE apikey = ? LIMIT 1");
$stmt->bind_param("s", $user_apikey);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($db_user_id, $limit_api, $hit_hari_ini);
$stmt->fetch();

if ($stmt->num_rows === 0) {
    $stmt->close();
    send_response(401, ['status' => false, 'message' => 'Unauthorized. Invalid API Key.']);
}

// Ubah limit_api ke integer jika memungkinkan
$limit_value = is_numeric($limit_api) ? (int)$limit_api : PHP_INT_MAX;

// Periksa apakah sudah mencapai limit
if ($hit_hari_ini >= $limit_value) {
    $stmt->close();
    send_response(429, ['status' => false, 'message' => 'Limit anda sudah mencapai batas, silahkan upgrade.']);
}

$stmt->close();

// 3. Buat Permintaan ke API Eksternal
$target_api_key = '2IlkUzIHCJNNVu4g5oRoCcNxeUTaxP3tJngs7uOf8x6pOqAGwoI72aQ3Vn3nhEuXfonu0kzmIm14RRge5xqPuDCQIq8icJvEaYFU';
$target_url = 'https://atlantich2h.com/transfer/cek_rekening';

$post_data = http_build_query([
    'api_key'        => $target_api_key,
    'bank_code'      => $bank_code,
    'account_number' => $account_number
]);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $target_url,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $post_data,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30
]);
$response_body = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_errno($ch)) {
    curl_close($ch);
    send_response(502, ['status' => false, 'message' => 'Bad Gateway. Failed to communicate with service provider.']);
}
curl_close($ch);

// 4. Proses Respons & Kurangi Limit HANYA JIKA SUKSES
$decoded_response = json_decode($response_body, true);

// Asumsi 'status': true menandakan sukses
if ($http_code == 200 && isset($decoded_response['status']) && $decoded_response['status'] == true) {
    
    // Limit hanya dikurangi jika panggilan API eksternal berhasil
    $update_stmt = $conn->prepare("UPDATE users SET hit_hari_ini = hit_hari_ini + 1, total_hit = total_hit + 1 WHERE id = ?");
    $update_stmt->bind_param("i", $db_user_id);
    $update_stmt->execute();
    $update_stmt->close();
    
    // Kirim respons sukses yang sudah dibungkus dengan info sisa limit
    $final_response = [
        'status' => true,
        'limit_tersisa' => is_numeric($limit_api) ? ((int)$limit_api - ($hit_hari_ini + 1)) : 'unlimited',
        'data' => $decoded_response['data']
    ];
    send_response(200, $final_response);

} else {
    // Jika status dari API eksternal false, JANGAN kurangi limit.
    // Teruskan pesan error dari provider ke pengguna.
    http_response_code($http_code);
    echo $response_body;
    exit();
}
?>
