<?php
// File: api/buy_paket.php

header('Content-Type: application/json');
require_once '../config.php'; // Koneksi database

// Ambil input dari GET
$apikey = isset($_GET['apikey']) ? trim($_GET['apikey']) : '';
$nama_paket = isset($_GET['nama_paket']) ? trim($_GET['nama_paket']) : '';

// Validasi input
if (empty($apikey) || empty($nama_paket)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'apikey dan nama_paket wajib diisi.'
    ]);
    exit();
}

// Cek user berdasarkan apikey
$user_query = $conn->prepare("SELECT id, username, saldo, masa_aktif FROM users WHERE apikey = ?");
$user_query->bind_param("s", $apikey);
$user_query->execute();
$user_result = $user_query->get_result();

if ($user_result->num_rows === 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'API key tidak valid.'
    ]);
    exit();
}

$user = $user_result->fetch_assoc();
$user_id = $user['id'];
$saldo_sekarang = $user['saldo'];
$masa_aktif_sekarang = $user['masa_aktif'];

// Cek paket berdasarkan nama_paket
$paket_query = $conn->prepare("SELECT * FROM paket_harga WHERE nama_paket = ?");
$paket_query->bind_param("s", $nama_paket);
$paket_query->execute();
$paket_result = $paket_query->get_result();

if ($paket_result->num_rows === 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Paket tidak ditemukan.'
    ]);
    exit();
}

$paket = $paket_result->fetch_assoc();
$harga = $paket['harga'];
$limit = $paket['limit_api'];
$masa_aktif_hari = $paket['masa_aktif_hari'];

// Cek saldo cukup atau tidak
if ($saldo_sekarang < $harga) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Saldo tidak mencukupi untuk membeli paket ini.',
        'saldo_anda' => $saldo_sekarang,
        'harga_paket' => $harga
    ]);
    exit();
}

// Kurangi saldo user
$new_saldo = $saldo_sekarang - $harga;

// Tentukan masa aktif baru (ditambahkan, bukan diganti)
$current_time = date('Y-m-d H:i:s');
if (!empty($masa_aktif_sekarang) && strtotime($masa_aktif_sekarang) > time()) {
    // Jika masa aktif masih berlaku → tambah dari masa aktif sekarang
    $masa_aktif_baru = date('Y-m-d H:i:s', strtotime($masa_aktif_sekarang . " +{$masa_aktif_hari} days"));
} else {
    // Jika masa aktif sudah habis → tambah dari sekarang
    $masa_aktif_baru = date('Y-m-d H:i:s', strtotime($current_time . " +{$masa_aktif_hari} days"));
}

// Update saldo + paket
$update_query = $conn->prepare("UPDATE users SET saldo = ?, limit_api = ?, masa_aktif = ? WHERE id = ?");
$update_query->bind_param("issi", $new_saldo, $limit, $masa_aktif_baru, $user_id);

if ($update_query->execute()) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Paket berhasil dibeli dan saldo telah dikurangi.',
        'data' => [
            'username' => $user['username'],
            'nama_paket' => $nama_paket,
            'harga' => $harga,
            'limit_api' => $limit,
            'saldo_sisa' => $new_saldo,
            'masa_aktif_baru' => $masa_aktif_baru
        ]
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Gagal membeli paket. Terjadi kesalahan saat update data.'
    ]);
}