<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
require_once '../config.php'; // koneksi database

// Konfigurasi
$api_key = "2IlkUzIHCJNNVu4g5oRoCcNxeUTaxP3tJngs7uOf8x6pOqAGwoI72aQ3Vn3nhEuXfonu0kzmIm14RRge5xqPuDCQIq8icJvEaYFU";
$target_url = "https://atlantich2h.com/deposit/metode";
$saveDir = __DIR__ . "/../uploads/metode/";

// Pastikan folder untuk menyimpan gambar tersedia
if (!is_dir($saveDir)) {
    mkdir($saveDir, 0777, true);
}

// 1. Ambil Data dari API Provider
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $target_url,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => http_build_query(['api_key' => $api_key]),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30
]);
$response_body = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200 || empty($response_body)) {
    echo json_encode(['status' => false, 'message' => 'Gagal mengambil data dari provider.']);
    exit;
}

// 2. Decode JSON
$data = json_decode($response_body, true);
if (!$data || !isset($data['status']) || $data['status'] !== true) {
    echo json_encode(['status' => false, 'message' => 'Data provider tidak valid.']);
    exit;
}

// 3. Simpan ke Database
foreach ($data['data'] as $metode) {
    $metode_code = $metode['metode'];
    $type = $metode['type'];
    $name = $metode['name'];
    $min = (float) $metode['min'];
    $max = (float) $metode['max'];
    $fee = (float) $metode['fee'] + 200; // tambahan nominal
    $fee_persen = (float) $metode['fee_persen'] + 0.2; // tambahan persen
    $status = $metode['status'];
    $img_url = $metode['img_url'];

    // Siapkan nama file lokal
    $fileName = basename(parse_url($img_url, PHP_URL_PATH));
    $savePath = $saveDir . $fileName;

    // Download gambar
    $ch = curl_init($img_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $imageData = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Jika berhasil diambil dan merupakan file gambar
    if ($httpCode === 200 && $imageData !== false) {
        file_put_contents($savePath, $imageData);
        $img_local = "/uploads/metode/" . $fileName;
    } else {
        // Jika gagal download, gunakan URL asli
        $img_local = $img_url;
    }

    // Insert atau Update jika sudah ada
    $stmt = $conn->prepare("
        INSERT INTO deposit_metode 
        (metode, type, name, min, max, fee, fee_persen, status, img_local)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
            type = VALUES(type),
            min = VALUES(min),
            max = VALUES(max),
            fee = VALUES(fee),
            fee_persen = VALUES(fee_persen),
            status = VALUES(status),
            img_local = VALUES(img_local)
    ");
    $stmt->bind_param(
        "sssddsdss",
        $metode_code,
        $type,
        $name,
        $min,
        $max,
        $fee,
        $fee_persen,
        $status,
        $img_local
    );
    $stmt->execute();
    $stmt->close();
}

// 4. Response
echo json_encode([
    'status' => true,
    'message' => 'Data metode deposit berhasil diambil & disimpan/update.',
    'jumlah_data' => count($data['data'])
]);

$conn->close();
?>