<?php
// Izinkan akses dari mana saja dan set tipe konten ke JSON
header("Access-Control-Allow-Origin: *"); 
header('Content-Type: application/json');

// Memuat file konfigurasi database Anda (misal: $conn)
require_once '../config.php';

// Fungsi helper untuk mengirim respons dan menghentikan skrip
function send_response($status_code, $data) {
    global $conn;
    if ($conn) {
        $conn->close();
    }
    http_response_code($status_code);
    echo json_encode($data);
    exit;
}

// ============== LANGKAH 1: Validasi Metode & Parameter Pengguna ==============
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    send_response(405, ['status' => false, 'message' => 'Method Not Allowed. Gunakan metode GET.']);
}

// Ambil parameter dari pengguna Anda
$user_apikey = isset($_GET['apikey']) ? trim($_GET['apikey']) : null;
$jenis_tagihan = isset($_GET['jenis_tagihan']) ? trim($_GET['jenis_tagihan']) : null;
$customer_no = isset($_GET['customer_no']) ? trim($_GET['customer_no']) : null;

if (empty($user_apikey) || empty($customer_no)) {
    send_response(400, [
        'status' => false,
        'message' => 'Bad Request. Parameter wajib: apikey, jenis_tagihan, customer_no.'
    ]);
}

// 2. Otentikasi API Key & Cek Limit
$db_user_id = null;
$limit_api = null;
$hit_hari_ini = null;

$stmt = $conn->prepare("SELECT id, limit_api, hit_hari_ini FROM users WHERE apikey = ? LIMIT 1");
$stmt->bind_param("s", $user_apikey);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($db_user_id, $limit_api, $hit_hari_ini);
$stmt->fetch();

if ($stmt->num_rows === 0) {
    $stmt->close();
    send_response(401, ['status' => false, 'message' => 'Unauthorized. Invalid API Key.']);
}

// Ubah limit_api ke integer jika memungkinkan
$limit_value = is_numeric($limit_api) ? (int)$limit_api : PHP_INT_MAX;

// Periksa apakah sudah mencapai limit
if ($hit_hari_ini >= $limit_value) {
    $stmt->close();
    send_response(429, ['status' => false, 'message' => 'Limit anda sudah mencapai batas, silahkan upgrade.']);
}

$stmt->close();

// ============== LANGKAH 3: Buat Permintaan ke API Digiflazz ==============

// Kredensial Digiflazz ANDA (bukan milik pengguna)
$digiflazz_username = 'hihuseoedYkg'; 
$digiflazz_apikey = '2f173500-ad55-560f-a9d2-a2fb7ec67224';   
$ref_id = bin2hex(random_bytes(6));
// URL endpoint Digiflazz untuk cek PLN
$target_url = 'https://api.digiflazz.com/v1/transaction';
$cmd = "inq-pasca";
// Buat signature sesuai formula Digiflazz
$signature = md5($digiflazz_username . $digiflazz_apikey . $ref_id);
if ($jenis_tagihan === "bpjs") {
    $buyer_sku_code = "kiri";
} else if ($jenis_tagihan === "plntagis") {
    $buyer_sku_code = "ABP115";
} else if ($jenis_tagihan === "gas_negara") {
    $buyer_sku_code = "pgas";
} else if ($jenis_tagihan === "dana") {
    $buyer_sku_code = "AV4799";
} else if ($jenis_tagihan === "ovo") {
    $buyer_sku_code = "pgas";
} else if ($jenis_tagihan === "gopay") {
    $buyer_sku_code = "pgas";
} else if ($jenis_tagihan === "gopay_drive") {
    $buyer_sku_code = "pgas";
} else if ($jenis_tagihan === "shopee") {
    $buyer_sku_code = "pgas";
} else if ($jenis_tagihan === "link_aja") {
    $buyer_sku_code = "pgas";
} else {
    // BLOKIR DI SINI: Jika jenis_tagihan tidak ada di atas
    $response = [
        'status'  => false,
        'message' => 'Jenis tagihan tidak valid atau tidak didukung.'
    ];
    
    // Kirim respons error dalam format JSON dan hentikan eksekusi script
    header('Content-Type: application/json');
    echo json_encode($response);
    die(); // atau exit();
}

// Siapkan data yang akan dikirim dalam format JSON
$post_data = json_encode([
    'username'    => $digiflazz_username,
    'customer_no' => $customer_no,
    'sign'        => $signature,
    'commands'    => $cmd,
    'ref_id'      => $ref_id,
    'buyer_sku_code' => $buyer_sku_code
]);

// Kirim permintaan menggunakan cURL
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $target_url,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $post_data,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [ // Header wajib untuk mengirim JSON
        'Content-Type: application/json'
    ],
    CURLOPT_TIMEOUT => 30
]);
$response_body = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_errno($ch)) {
    curl_close($ch);
    send_response(502, ['status' => false, 'message' => 'Bad Gateway. Gagal terhubung ke provider.']);
}
curl_close($ch);

// ============== LANGKAH 4: Proses Respons & Kurangi Limit ==============
$decoded_response = json_decode($response_body, true);

// Cek jika respons dari Digiflazz sukses.
// Sukses ditandai dengan adanya key 'data' dan di dalamnya ada 'customer_name'
if ($http_code == 200 && isset($decoded_response['data'])) {
    
    // **PENTING**: Limit hanya dikurangi jika panggilan ke Digiflazz berhasil
    $update_stmt = $conn->prepare("UPDATE users SET hit_hari_ini = hit_hari_ini + 1, total_hit = total_hit + 1 WHERE id = ?");
    $update_stmt->bind_param("s", $db_user_id);
    $update_stmt->execute();
    $update_stmt->close();
    $data_yang_dipilih = [
        'nomor_pelanggan' => $decoded_response['data']['customer_no'],
        'nama_pelanggan'  => $decoded_response['data']['customer_name'],
        'alamat'          => $decoded_response['data']['desc']['alamat'], // Mengambil dari dalam 'desc'
        'jumlah_peserta'  => $decoded_response['data']['desc']['jumlah_peserta'] // Mengambil dari dalam 'desc'
    ];
    
    // 2. Masukkan data yang sudah dipilih ke dalam respons akhir Anda
    $final_response = [
        'status'        => true,
        'limit_tersisa' => is_numeric($limit_api) ? ((int)$limit_api - ($hit_hari_ini + 1)) : 'unlimited',
        'data'          => $data_yang_dipilih // Gunakan array yang baru dibuat
    ];
        send_response(200, $final_response);

} else {
    // Jika panggilan ke Digiflazz gagal, JANGAN kurangi limit.
    // Teruskan pesan error dari Digiflazz ke pengguna Anda.
    http_response_code($http_code); // Gunakan status code asli dari Digiflazz
    echo $response_body;
    exit();
}
?>
