<?php
// Set header untuk response JSON
header("Content-Type: application/json; charset=UTF-8");

// Panggil file konfigurasi untuk koneksi database
require_once '../config.php';

// ===================================================
// FUNGSI UNTUK MENGIRIM RESPONSE DAN KELUAR
// ===================================================
function send_response($code, $status, $message) {
    global $conn;
    http_response_code($code);
    echo json_encode(["status" => $status, "message" => $message]);
    $conn->close();
    exit();
}

// ===================================================
// VALIDASI PARAMETER URL
// ===================================================
// Tambahkan 'amount' ke dalam validasi
if (!isset($_GET['apikey']) || !isset($_GET['type']) || !isset($_GET['target_apikey']) || !isset($_GET['amount'])) {
    send_response(400, "error", "Missing required parameters: apikey, type, target_apikey, amount.");
}

// Validasi bahwa amount adalah angka positif
$amount = $_GET['amount'];
if (!is_numeric($amount) || $amount <= 0) {
    send_response(400, "error", "Invalid amount. It must be a positive number.");
}
$amount = (int)$amount; // Ubah menjadi integer

$admin_key = $_GET['apikey'];
$action_type = strtolower($_GET['type']);
$target_key = $_GET['target_apikey'];

// ===================================================
// OTORISASI: Cek apakah apikey adalah admin
// ===================================================
$sql_auth = "SELECT role FROM users WHERE apikey = ?";
$stmt_auth = $conn->prepare($sql_auth);
$stmt_auth->bind_param("s", $admin_key);
$stmt_auth->execute();
$result_auth = $stmt_auth->get_result();

if ($result_auth->num_rows === 0) {
    send_response(403, "error", "Forbidden: Invalid admin API Key.");
}

$admin_data = $result_auth->fetch_assoc();
if ($admin_data['role'] !== 'admin') {
    send_response(403, "error", "Forbidden: You do not have permission to perform this action.");
}
$stmt_auth->close();

// ===================================================
// LOGIKA UTAMA: TAMBAH ATAU KURANG LIMIT
// ===================================================
$sql_update = "";

switch ($action_type) {
    case 'tambah':
        // Gunakan placeholder '?' untuk jumlah
        $sql_update = "UPDATE users SET limit_api = limit_api + ? WHERE apikey = ?";
        $stmt_update = $conn->prepare($sql_update);
        $stmt_update->bind_param("is", $amount, $target_key); // i: integer, s: string
        break;

    case 'kurang':
        // Gunakan placeholder '?' dan pastikan limit tidak menjadi negatif
        $sql_update = "UPDATE users SET limit_api = limit_api - ? WHERE apikey = ? AND limit_api >= ?";
        $stmt_update = $conn->prepare($sql_update);
        $stmt_update->bind_param("isi", $amount, $target_key, $amount); // i: integer, s: string, i: integer
        break;

    default:
        send_response(400, "error", "Invalid type. Use 'tambah' or 'kurang'.");
}

// Eksekusi query update
$stmt_update->execute();

if ($stmt_update->affected_rows > 0) {
    $action_word = ($action_type == 'tambah' ? 'incremented by' : 'decremented by');
    $message = "Successfully $action_word $amount for API key: $target_key";
    send_response(200, "success", $message);
} else {
    send_response(404, "error", "Target API Key not found or action could not be completed (e.g., insufficient limit).");
}

$stmt_update->close();
$conn->close();
?>
