<?php
header("Access-Control-Allow-Origin: *"); 
header('Content-Type: application/json');

// Panggil konfigurasi database
require_once '../config.php';

// ===================================================
// FUNGSI UNTUK MENGIRIM RESPONSE
// ===================================================
function send_response($code, $status, $message, $data = null) {
    global $conn;
    http_response_code($code);
    $response = ["status" => $status, "message" => $message];
    if ($data !== null) {
        $response['data'] = $data;
    }
    echo json_encode($response);
    if ($conn) {
        $conn->close();
    }
    exit();
}

// ===================================================
// VALIDASI PARAMETER GET
// ===================================================
if (
    !isset($_GET['apikey']) || 
    !isset($_GET['nama_paket']) || 
    !isset($_GET['harga']) || 
    !isset($_GET['limit_api']) || 
    !isset($_GET['masa_aktif_hari'])
) {
    send_response(400, "error", "Missing required parameters: apikey, nama_paket, harga, limit_api, masa_aktif_hari.");
}

// Ambil data dari GET
$admin_key = $_GET['apikey'];
$nama_paket = trim($_GET['nama_paket']);
$harga = $_GET['harga'];
$limit_api = $_GET['limit_api'];
$masa_aktif_hari = $_GET['masa_aktif_hari'];

// Validasi angka positif
if (!is_numeric($harga) || $harga <= 0 || !is_numeric($limit_api) || $limit_api <= 0 || !is_numeric($masa_aktif_hari) || $masa_aktif_hari <= 0) {
    send_response(400, "error", "Invalid numeric input. harga, limit_api, dan masa_aktif_hari must be positive numbers.");
}

// ===================================================
// OTORISASI: Pastikan API Key admin
// ===================================================
$sql_auth = "SELECT id, role FROM users WHERE apikey = ?";
$stmt_auth = $conn->prepare($sql_auth);
$stmt_auth->bind_param("s", $admin_key);
$stmt_auth->execute();
$result_auth = $stmt_auth->get_result();

if ($result_auth->num_rows === 0) {
    send_response(403, "error", "Forbidden: Invalid admin API Key.");
}

$admin_data = $result_auth->fetch_assoc();
if ($admin_data['role'] !== 'admin') {
    send_response(403, "error", "Forbidden: You do not have permission to perform this action.");
}
$stmt_auth->close();

// ===================================================
// SIMPAN PAKET KE DATABASE
// ===================================================
$sql_insert = "INSERT INTO paket_harga (nama_paket, harga, limit_api, masa_aktif_hari) VALUES (?, ?, ?, ?)";
$stmt_insert = $conn->prepare($sql_insert);
$stmt_insert->bind_param("siii", $nama_paket, $harga, $limit_api, $masa_aktif_hari);
$stmt_insert->execute();

if ($stmt_insert->affected_rows > 0) {
    $new_id = $conn->insert_id;
    send_response(201, "success", "Paket berhasil dibuat.", [
        'id' => $new_id,
        'nama_paket' => $nama_paket,
        'harga' => (int)$harga,
        'limit_api' => (int)$limit_api,
        'masa_aktif_hari' => (int)$masa_aktif_hari
    ]);
} else {
    send_response(500, "error", "Gagal membuat paket. Terjadi kesalahan database.");
}

$stmt_insert->close();
$conn->close();
?>