<?php
// Mengatur header agar outputnya selalu JSON
header("Access-Control-Allow-Origin: *"); 
header('Content-Type: application/json');

// Memanggil file koneksi database
require_once '../config.php';

function send_response($status_code, $data) {
    http_response_code($status_code);
    echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

// 1. Validasi Metode & Parameter
// ======================================================================
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    send_response(405, ['success' => false, 'message' => 'Method Not Allowed. Use GET.']);
}

$apikey = isset($_GET['apikey']) ? trim($_GET['apikey']) : null;
$ref_id = isset($_GET['ref_id']) ? trim($_GET['ref_id']) : null; // ID transaksi dari sistem Anda

if (empty($apikey) || empty($ref_id)) {
    send_response(400, ['success' => false, 'message' => "Bad Request. Parameters required: apikey, ref_id."]);
}

// 2. Otentikasi & Validasi Transaksi
// ======================================================================
// Cek apikey
$stmt = $conn->prepare("SELECT id FROM users WHERE apikey = ? LIMIT 1");
$stmt->bind_param("s", $apikey);
$stmt->execute();
if ($stmt->get_result()->num_rows === 0) {
    $stmt->close();
    send_response(401, ['success' => false, 'message' => 'Unauthorized. Invalid API Key.']);
}
$stmt->close();

// Cek apakah transaksi ada dan milik pengguna yang benar
$stmt_trans = $conn->prepare("SELECT id_provider FROM transaksi_transfer WHERE id_transaksi = ? AND apikey = ?");
$stmt_trans->bind_param("ss", $ref_id, $apikey);
$stmt_trans->execute();
$transaksi = $stmt_trans->get_result()->fetch_assoc();
if (!$transaksi || empty($transaksi['id_provider'])) {
    $stmt_trans->close();
    send_response(404, ['success' => false, 'message' => 'Transaction not found or provider ID is missing.']);
}
$stmt_trans->close();
$id_to_check = $transaksi['id_provider']; // Gunakan ID ini untuk cek status


// 3. Ambil Konfigurasi Provider
// ======================================================================
$stmt_gw = $conn->prepare("SELECT apikey FROM payment_setting WHERE nama = 'atlantich2h'");
$stmt_gw->execute();
$provider_config = $stmt_gw->get_result()->fetch_assoc();
$stmt_gw->close();

if (!$provider_config) {
    send_response(503, ['success' => false, 'message' => 'Service Unavailable. Provider configuration not found.']);
}

// 4. Kirim Permintaan ke API Provider
// ======================================================================
$target_url = 'https://atlantich2h.com/transfer/status';
// 'id' yang dikirim adalah ID dari provider
$post_data = http_build_query([
    'api_key' => $provider_config['apikey'],
    'id' => $id_to_check 
]);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $target_url,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $post_data,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded'],
    CURLOPT_TIMEOUT => 30
]);

$response_body = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// 5. Proses dan Teruskan Respons
// ======================================================================
$decoded_response = json_decode($response_body, true);

if ($http_code == 200 && isset($decoded_response['status']) && $decoded_response['status'] == true) {
    // Jika status dari provider 'Success', 'Gagal', atau 'Refund', update database lokal Anda
    $provider_status = $decoded_response['data']['status'] ?? null;
    $db_status = null;

    if ($provider_status == 'Success') {
        $db_status = 'Success';
    } elseif ($provider_status == 'Gagal' || $provider_status == 'Refund') {
        $db_status = 'Failed';
    }
    
    if ($db_status) {
        $stmt_update = $conn->prepare("UPDATE transaksi_transfer SET status = ?, keterangan_provider = ? WHERE id_transaksi = ?");
        $stmt_update->bind_param("sss", $db_status, $response_body, $ref_id);
        $stmt_update->execute();
    }
    
    send_response(200, [
        'success' => true,
        'data' => $decoded_response['data']
    ]);

} else {
    send_response(502, [
        'success' => false,
        'message' => 'Failed to get status from provider.',
        'provider_response' => $decoded_response
    ]);
}
?>
