<?php
// Set header untuk memberitahu klien bahwa responsnya adalah JSON
header("Content-Type: application/json; charset=UTF-8");
// Izinkan akses dari mana saja (Penting untuk testing dari HTML)
header("Access-Control-Allow-Origin: *");
// Izinkan metode GET
header("Access-Control-Allow-Methods: GET");
// Izinkan header tertentu yang mungkin dikirim oleh klien
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
require_once '../config.php';
// 1. PERUBAHAN: Validasi input, wajibkan salah satu antara email_user atau id_user
$user_apikey = isset($_GET['apikey']) ? trim($_GET['apikey']) : null;
if (
    !isset($_GET['token']) ||
    (!isset($_GET['email_user']) && !isset($_GET['id_user'])) || // Cek jika KEDUANYA tidak ada
    !isset($_GET['tipe']) ||
    !isset($_GET['jumlah'])
) {
    http_response_code(400); // Bad Request
    echo json_encode([
        'status' => 'gagal',
        'pesan' => 'Input tidak lengkap. Parameter token, (email_user ATAU id_user), tipe, dan jumlah wajib diisi.'
    ]);
    exit();
}

// 2. VALIDASI BARU: Cek nilai parameter 'notifikasi' jika ada
if (isset($_GET['notifikasi'])) {
    // Daftar nilai yang diizinkan (dibuat case-insensitive)
    $allowed_values = ['true', 'false', '1', '0'];
    $notif_value = strtolower($_GET['notifikasi']);

    // Jika nilai yang diberikan tidak ada dalam daftar yang diizinkan
    if (!in_array($notif_value, $allowed_values)) {
        // Hentikan proses dan tampilkan pesan error
        http_response_code(400); // Bad Request
        echo json_encode([
            'status' => 'gagal',
            'pesan' => "Nilai untuk parameter 'notifikasi' tidak valid. Silakan gunakan 'true' atau 'false'."
        ]);
        exit();
    }
}

// 3. Ambil data dari parameter URL ($_GET) setelah semua validasi lolos
$token = $_GET['token'];
$tipe = $_GET['tipe'];
$jumlah = (int)$_GET['jumlah'];
// Konversi nilai notifikasi menjadi boolean. Akan bernilai false jika tidak ada.
$notifikasi = isset($_GET['notifikasi']) && filter_var($_GET['notifikasi'], FILTER_VALIDATE_BOOLEAN);

// 4. Siapkan header untuk cURL
$header = ["Authorization: Bearer " . $token];

// 5. PERUBAHAN: Siapkan body request dan tambahkan email_user atau id_user secara dinamis
$post_body = [
  "tipe" => $tipe,
  "jumlah" => $jumlah,
  "notifikasi" => $notifikasi
];

// Tambahkan user identifier berdasarkan parameter yang diberikan
if (isset($_GET['email_user'])) {
    $post_body['email_user'] = $_GET['email_user'];
} else {
    $post_body['id_user'] = $_GET['id_user'];
}


// 6. Logika kondisional untuk parameter tambahan
if ($notifikasi === true) {
    if (!isset($_GET['judul_notifikasi']) || !isset($_GET['pesan_notifikasi']) || !isset($_GET['catatan_saldo'])) {
        http_response_code(400);
        echo json_encode([
            'status' => 'gagal',
            'pesan' => 'Jika notifikasi true, parameter judul_notifikasi, pesan_notifikasi, dan catatan_saldo wajib diisi.'
        ]);
        exit();
    }
    $post_body['judul_notifikasi'] = $_GET['judul_notifikasi'];
    $post_body['pesan_notifikasi'] = $_GET['pesan_notifikasi'];
    $post_body['catatan_saldo'] = $_GET['catatan_saldo'];
}

if ($tipe === 'kurang') {
    if (!isset($_GET['pin'])) {
        http_response_code(400);
        echo json_encode([
            'status' => 'gagal',
            'pesan' => 'Jika tipe adalah kurang, parameter pin wajib diisi.'
        ]);
        exit();
    }
    $post_body['pin'] = $_GET['pin'];
}


// 7. Eksekusi cURL ke API BukaOlshop
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://bukaolshop.net/api/v1/member/saldo");
curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
curl_setopt($ch, CURLOPT_POST, TRUE);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_body));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$hasil = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// 8. Kembalikan hasil dari API BukaOlshop
http_response_code($http_code);
echo $hasil;

?>
