document.addEventListener('DOMContentLoaded', function() {

    // --- LOGIKA UNTUK SIDEBAR MENU ---
    const menuIcon = document.querySelector('.menu-icon');
    const sidebar = document.getElementById('sidebar');
    const closeBtn = document.getElementById('closeBtn');
    const overlay = document.getElementById('overlay');

    const openSidebar = () => {
        if (sidebar) sidebar.classList.add('active');
        if (overlay) overlay.classList.add('active');
    };

    const closeSidebar = () => {
        if (sidebar) sidebar.classList.remove('active');
        if (overlay) overlay.classList.remove('active');
    };

    if (menuIcon) menuIcon.addEventListener('click', openSidebar);
    if (closeBtn) closeBtn.addEventListener('click', closeSidebar);
    if (overlay) overlay.addEventListener('click', closeSidebar);


    // --- LOGIKA UNTUK TOMBOL SALIN APIKEY ---
    const copyButton = document.getElementById('copyButton');
    const apiKeyElement = document.getElementById('apiKey');

    if (copyButton && apiKeyElement) {
        const originalButtonHTML = copyButton.innerHTML;

        copyButton.addEventListener('click', () => {
            const apiKeyToCopy = apiKeyElement.textContent.trim();
            
            navigator.clipboard.writeText(apiKeyToCopy).then(() => {
                copyButton.innerHTML = `
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-circle-fill" viewBox="0 0 16 16">
                        <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z"/>
                    </svg>
                    Tersalin!
                `;
                copyButton.disabled = true;

                setTimeout(() => {
                    copyButton.innerHTML = originalButtonHTML;
                    copyButton.disabled = false;
                }, 2000);
            }).catch(err => {
                console.error('Gagal menyalin: ', err);
                alert('Gagal menyalin apikey.');
            });
        });
    }
});


// Dapatkan elemen tombol dan dropdown
const avatarBtn = document.getElementById("avatarBtn");
const dropdown = document.getElementById("myDropdown");

// Tambahkan event listener untuk toggle menu saat avatar diklik
avatarBtn.onclick = function() {
    dropdown.classList.toggle("show");
};

// Tutup dropdown jika pengguna mengklik di luar menu
window.onclick = function(event) {
    if (!event.target.closest('.profile-avatar')) {
        if (dropdown.classList.contains('show')) {
            dropdown.classList.remove('show');
        }
    }
};


document.addEventListener('DOMContentLoaded', function() {
    // === ELEMEN-ELEMEN PENTING ===
    const modal = document.getElementById('paymentModal');
    if (!modal) return;

    const closeButton = modal.querySelector('.close-button');
    const orderButtons = document.querySelectorAll('.order-button');
    const confirmButton = document.getElementById('confirm-payment-button');

    // Detail Modal
    const modalPackName = document.getElementById('modal-packname');
    const modalLimit = document.getElementById('modal-limit');
    const modalDuration = document.getElementById('modal-duration');
    const modalPrice = document.getElementById('modal-price');
    const modalFee = document.getElementById('modal-fee');
    const modalTotal = document.getElementById('modal-total');
    
    // Metode Pembayaran
    const paymentMethodRadios = document.querySelectorAll('input[name="paymentMethod"]');
    const balanceOptionContainer = document.getElementById('balanceOptionContainer');
    const qrisOptionContainer = document.getElementById('qrisOptionContainer');
    const userBalanceDisplay = document.getElementById('user-balance-display');
    const payWithBalanceRadio = document.getElementById('payWithBalance');
    const payWithQrisRadio = document.getElementById('payWithQris');

    // === DATA & FUNGSI BANTUAN ===
    const userBalance = parseInt(modal.dataset.userBalance) || 0;
    userBalanceDisplay.textContent = formatRupiah(userBalance);

    function formatRupiah(number) {
        return new Intl.NumberFormat('id-ID', {
            style: 'currency',
            currency: 'IDR',
            minimumFractionDigits: 0
        }).format(number);
    }
    
    // === FUNGSI UTAMA ===

    // Fungsi untuk menangani pembayaran dengan saldo
    async function handleBalancePayment(event) {
        event.preventDefault(); // Mencegah link default
        const paketId = parseInt(modal.dataset.paketId);
        if (!paketId) {
            alert('Error: ID Paket tidak ditemukan.');
            return;
        }

        // Tampilkan loading & nonaktifkan tombol
        confirmButton.textContent = 'Memproses...';
        confirmButton.classList.add('disabled');

        try {
            const response = await fetch('process-payment.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    paket_id: paketId,
                    method: 'saldo'
                })
            });

            const result = await response.json();

            if (result.status === 'success') {
                // Tampilkan pesan sukses dan arahkan ke halaman invoice
                alert(result.message); // Bisa diganti dengan notifikasi yang lebih cantik (e.g., SweetAlert)
                window.location.href = `invoice.php?id=${result.invoice_id}`;
            } else {
                // Tampilkan pesan error dari server
                throw new Error(result.message || 'Terjadi kesalahan pada server.');
            }

        } catch (error) {
            alert('Error: ' + error.message);
            // Kembalikan tombol ke state semula jika gagal
            confirmButton.textContent = 'Konfirmasi & Bayar dengan Saldo';
            confirmButton.classList.remove('disabled');
        }
    }


    function calculateCosts(basePrice, method) {
        let fee = 0;
        if (method === 'qris' && basePrice > 0) {
            fee = Math.round((basePrice * 0.014) + 200);
        }
        const total = basePrice + fee;
        return { fee, total };
    }

    function updatePaymentUI() {
        const selectedMethod = document.querySelector('input[name="paymentMethod"]:checked').value;
        const basePrice = parseInt(modal.dataset.basePrice) || 0;
        const packName = modal.dataset.packName || '';

        const { fee, total } = calculateCosts(basePrice, selectedMethod);

        modalFee.textContent = formatRupiah(fee);
        modalTotal.textContent = formatRupiah(total);

        balanceOptionContainer.classList.toggle('selected', selectedMethod === 'saldo');
        qrisOptionContainer.classList.toggle('selected', selectedMethod === 'qris');
        
        // Hapus event listener lama sebelum menambahkan yang baru untuk mencegah duplikasi
        confirmButton.onclick = null;

        if (selectedMethod === 'saldo') {
            confirmButton.textContent = 'Konfirmasi & Bayar dengan Saldo';
            confirmButton.href = '#';
            confirmButton.classList.remove('disabled');
            confirmButton.onclick = handleBalancePayment; // Set fungsi baru
        } else { // Metode QRIS
            confirmButton.textContent = 'Lanjutkan ke QRIS';
            confirmButton.classList.remove('disabled');
            const pesanWA = `Halo, saya mau order paket *${packName}* total *${formatRupiah(total)}* via QRIS.`;
            confirmButton.href = `https://api.whatsapp.com/send?phone=628xxxx&text=${encodeURIComponent(pesanWA)}`; // Ganti 628xxxx
        }
    }

    function openModal(event) {
        const button = event.currentTarget;
        const basePrice = parseInt(button.dataset.price);

        // Simpan data penting ke modal
        modal.dataset.paketId = button.dataset.id; // <-- PENTING
        modal.dataset.basePrice = basePrice;
        modal.dataset.packName = button.dataset.packname;
        
        const limit = parseInt(button.dataset.limit) >= 1000 ? (parseInt(button.dataset.limit) / 1000) + 'K' : button.dataset.limit;
        const durationDays = parseInt(button.dataset.duration);
        let durationText = durationDays + ' Hari';
        if (durationDays >= 30) {
            const months = Math.round(durationDays / 30);
            durationText = 'Active ' + months + ' Month';
        }

        modalPackName.textContent = button.dataset.packname;
        modalLimit.textContent = limit + ' Limit';
        modalDuration.textContent = durationText;
        modalPrice.textContent = formatRupiah(basePrice);

        const balanceDesc = balanceOptionContainer.querySelector('.method-desc');
        if (userBalance >= basePrice) {
            payWithBalanceRadio.disabled = false;
            balanceOptionContainer.classList.remove('disabled');
            balanceDesc.textContent = `Saldo Anda: ${formatRupiah(userBalance)}`;
            payWithBalanceRadio.checked = true;
        } else {
            payWithBalanceRadio.disabled = true;
            balanceOptionContainer.classList.add('disabled');
            balanceDesc.innerHTML = `Saldo: ${formatRupiah(userBalance)} <span class="insufficient">(Tidak Cukup)</span>`;
            payWithQrisRadio.checked = true;
        }
        
        updatePaymentUI();
        modal.style.display = 'flex';
    }

    function closeModal() {
        modal.style.display = 'none';
    }

    // === EVENT LISTENERS ===
    orderButtons.forEach(button => button.addEventListener('click', openModal));
    paymentMethodRadios.forEach(radio => radio.addEventListener('change', updatePaymentUI));
    closeButton.addEventListener('click', closeModal);
    window.addEventListener('click', (event) => {
        if (event.target === modal) {
            closeModal();
        }
    });
});