<?php
require_once '../config.php';
require_once '../setting.php';

// --- MODIFIKASI RECAPTCHA V3 ---
// Ganti dengan Secret Key v3 Anda


$error_message = '';
$success_message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // --- MODIFIKASI RECAPTCHA V3: Validasi token dan skor ---
    if (isset($_POST['g-recaptcha-response']) && !empty($_POST['g-recaptcha-response'])) {
        
        $verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret=' . $secretrecaptcha . '&response=' . $_POST['g-recaptcha-response']);
        $responseData = json_decode($verifyResponse);

        // Periksa apakah request berhasil DAN skornya di atas ambang batas (misal: 0.5)
        // Anda juga bisa memeriksa 'action' jika perlu: && $responseData->action == 'register'
        if ($responseData->success && $responseData->score >= 0.5) {
            
            // --- LOGIKA REGISTRASI ANDA TETAP SAMA, DI DALAM SINI ---
            $username = $conn->real_escape_string(trim($_POST['username']));
            $email = $conn->real_escape_string(trim($_POST['email']));
            $nomor = $conn->real_escape_string(trim($_POST['nomor']));
            $password = $conn->real_escape_string(trim($_POST['password']));

            if (empty($username) || empty($email) || empty($nomor) || empty($password)) {
                $error_message = "Username, email, nomor, dan password tidak boleh kosong!";
            } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $error_message = "Format email tidak valid!";
            } elseif (!preg_match('/^[0-9]{10,15}$/', $nomor)) {
                $error_message = "Format nomor WhatsApp tidak valid!";
            } else {
                $stmt_check = $conn->prepare("SELECT id FROM users WHERE username = ? OR email = ? OR nomor = ?");
                $stmt_check->bind_param("sss", $username, $email, $nomor);
                $stmt_check->execute();
                $stmt_check->store_result();

                if ($stmt_check->num_rows > 0) {
                    $error_message = "Username, Email atau nomor sudah terdaftar.";
                } else {
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                    $api_key = bin2hex(random_bytes(6));
                    $limit_api = 10;

                    $stmt_insert = $conn->prepare("INSERT INTO users (username, email, nomor, password, apikey, limit_api) VALUES (?, ?, ?, ?, ?, ?)");
                    $stmt_insert->bind_param("ssssss", $username, $email, $nomor, $hashed_password, $api_key, $limit_api);

                    if ($stmt_insert->execute()) {
                        $success_message = "Registrasi berhasil! Silakan login.";
                    } else {
                        $error_message = "Terjadi kesalahan saat registrasi.";
                    }
                    $stmt_insert->close();
                }
                $stmt_check->close();
            }
            // --- AKHIR DARI LOGIKA REGISTRASI ---

        } else {
            // Jika skor reCAPTCHA terlalu rendah
            $error_message = "Verifikasi keamanan gagal. Silakan coba lagi.";
        }
    } else {
        // Jika token reCAPTCHA tidak ada
        $error_message = "Verifikasi keamanan gagal. Harap muat ulang halaman.";
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrasi</title>
    <style>
      /* Style Anda tetap sama */
      body { display: flex; justify-content: center; align-items: center; min-height: 100vh; font-family: sans-serif; background-color: #00a4ff; padding: 20px 0; }
      .container { width: 300px; padding: 2rem; background: #fff; border-radius: 8px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); }
      h2 { margin-bottom: 1.5rem; color: #000; text-align: center; }
      .form-group { margin-bottom: 1rem; width: 100%; color: #000;}
      label { display: block; margin-bottom: 0.5rem; }
      input { padding: 0.5rem; width: 100%; box-sizing: border-box; border: 1px solid #ccc; border-radius: 4px; }
      button { width: 100%; padding: 0.7rem; color: #fff; background-color: #28a745; border: none; border-radius: 4px; cursor: pointer; }
      .message { margin-top: 1rem; padding: 0.7rem; border-radius: 4px; text-align: center; }
      .message.error { color: #721c24; background-color: #f8d7da; }
      .message.success { color: #155724; background-color: #d4edda; }
      .login-link { color: #000; margin-top: 1rem; text-align: center; }
      .login-link a{ color: #a9a5a5; text-decoration: none; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Registrasi</h2>
        <?php if ($error_message): ?>
            <div class="message error"><?php echo $error_message; ?></div>
        <?php endif; ?>
        <?php if ($success_message): ?>
            <div class="message success"><?php echo $success_message; ?></div>
        <?php endif; ?>

        <form id="register-form" action="daftar" method="post"> 
            <div class="form-group">
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" required>
            </div>
            
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" required>
            </div>
            
            <div class="form-group">
                <label for="nomor">No Whatsapp:</label>
                <input type="tel" id="nomor" name="nomor" required pattern="[0-9]{10,15}" title="Harap masukkan 10-15 digit angka.">
            </div>

            <div class="form-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <button type="submit">Daftar</button>
        </form>
        <div class="login-link">
            <p>Sudah punya akun? <a href="/login">Login di sini</a></p>
        </div>
    </div>
    <script src="https://www.google.com/recaptcha/api.js?render=<? echo $sitekeyrecaptcha;?>"></script>
    <script>
        document.getElementById('register-form').addEventListener('submit', function(e) {
            // Hentikan pengiriman form sementara
            e.preventDefault(); 
            var form = this;
            
            grecaptcha.ready(function() {
                // Ganti dengan Site Key v3 Anda lagi di sini
                grecaptcha.execute('<?php echo $sitekeyrecaptcha; ?>', {action: 'register'}).then(function(token) {
                    // Buat input tersembunyi untuk token
                    var tokenInput = document.createElement('input');
                    tokenInput.type = 'hidden';
                    tokenInput.name = 'g-recaptcha-response';
                    tokenInput.value = token;
                    // Tambahkan ke form
                    form.appendChild(tokenInput);
                    // Lanjutkan pengiriman form
                    form.submit();
                });
            });
        });
    </script>
</body>
</html>
