<?php
// Path ini sudah benar jika file ini ada di dalam folder /auth
require_once '../config.php';

$error_message = '';
$success_message = '';

// Cek jika form telah disubmit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ambil data dari form
    $username = $conn->real_escape_string(trim($_POST['username']));
    $password = $conn->real_escape_string(trim($_POST['password']));

    // Validasi input tidak boleh kosong
    if (empty($username) || empty($password)) {
        $error_message = "Username dan password baru tidak boleh kosong!";
    } else {
        // Cek apakah username SUDAH ADA (logika dibalik)
        $stmt_check = $conn->prepare("SELECT id FROM users WHERE username = ?");
        $stmt_check->bind_param("s", $username);
        $stmt_check->execute();
        $stmt_check->store_result();

        // JIKA USERNAME DITEMUKAN, LANJUTKAN UPDATE PASSWORD
        if ($stmt_check->num_rows > 0) {
            
            // Hash password BARU untuk keamanan
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            // Siapkan statement UPDATE
            $update_stmt = $conn->prepare("UPDATE users SET password = ? WHERE username = ?");
            $update_stmt->bind_param("ss", $hashed_password, $username);

            // Eksekusi dan berikan pesan
            if ($update_stmt->execute()) {
                $success_message = "Password untuk username '" . htmlspecialchars($username) . "' berhasil diubah. Silakan login.";
            } else {
                $error_message = "Terjadi kesalahan saat memperbarui password.";
            }
            $update_stmt->close();

        } else {
            // JIKA USERNAME TIDAK DITEMUKAN, tampilkan error
            $error_message = "Username tidak ditemukan.";
        }
        $stmt_check->close();
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password</title>
    <style>
      /* Menggunakan CSS yang sama, tidak perlu diubah */
      body { display: flex; justify-content: center; align-items: center; height: 100vh; font-family: sans-serif; background-color: #00a4ff; }
      .container { width: 300px; padding: 2rem; background: #fff; border-radius: 8px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); }
      h2 { margin-bottom: 1.5rem; text-align: center; }
      .form-group { margin-bottom: 1rem; width: 100%; }
      label { display: block; margin-bottom: 0.5rem; }
      input { padding: 0.5rem; width: 100%; box-sizing: border-box; border: 1px solid #ccc; border-radius: 4px; }
      button { width: 100%; padding: 0.7rem; color: #fff; background-color: #dc3545; border: none; border-radius: 4px; cursor: pointer; }
      .message { margin-top: 1rem; padding: 0.7rem; border-radius: 4px; text-align: center; }
      .message.error { color: #721c24; background-color: #f8d7da; }
      .message.success { color: #155724; background-color: #d4edda; }
      .login-link { margin-top: 1rem; text-align: center; }
      .login-link a{
        color: #a9a5a5; 
        text-decoration: none;
      }
    </style>
</head>
<body>
    <div class="container">
        <h2>Lupa Password</h2>

        <?php if ($error_message): ?>
            <div class="message error"><?php echo $error_message; ?></div>
        <?php endif; ?>
        <?php if ($success_message): ?>
            <div class="message success"><?php echo $success_message; ?></div>
        <?php endif; ?>

        <form action="lupa-password" method="post"> 
            <div class="form-group">
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">Password Baru:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit">Reset Password</button>
        </form>

        <div class="login-link">
            <p>Ingat password Anda? <a href="/login">Login di sini</a></p>
        </div>
    </div>
</body>
</html>
