<?php
// Function to fetch data from API using cURL
function fetchData($url, $token) {
    $header = ["Authorization: Bearer " . $token];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout in seconds
    $hasil = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Return data only on success (HTTP 200)
    if ($httpcode == 200) {
        return json_decode($hasil, true);
    }
    return null;
}

// Initialize variables
$nama_aplikasi = $paket = $masa_aktif = $limit_request = $terpakai = $tersisa = $error_message = null;

// Process the form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['api_key'])) {
    $apiKey = $_POST['api_key'];

    // Fetch data from the two endpoints
    $infoData = fetchData("https://bukaolshop.net/api/v1/aplikasi/info", $apiKey);
    $limitData = fetchData("https://bukaolshop.net/api/v1/aplikasi/info_limit", $apiKey);

    // Check if both API calls were successful
    if ($infoData && $limitData) {
        // --- Process data from /info ---
        $nama_aplikasi = htmlspecialchars($infoData['nama_aplikasi']);
        // Capitalize the first letter of the package name
        $paket = ucfirst(htmlspecialchars($infoData['status_premium']));
        
        $img = ucfirst(htmlspecialchars($infoData['icon_aplikasi']));

        // Format the date to Indonesian format (e.g., 19 Agustus 2025)
        try {
            $date = new DateTime($infoData['masa_aktif_premium']);
            $formatter = new IntlDateFormatter('id_ID', IntlDateFormatter::LONG, IntlDateFormatter::NONE);
            $masa_aktif = $formatter->format($date);
        } catch (Exception $e) {
            $masa_aktif = $infoData['masa_aktif_premium']; // Fallback to raw date
        }

        // --- Process data from /info_limit ---
        $terpakai = (int)$limitData['jumlah_request'];

        // --- Business Logic ---
        // Determine the request limit based on the package type (customize as needed)
        // This is based on the example in the image ("Bisnis" package has a 700 limit)
        if (strtolower($paket) == 'bisnis') {
            $limit_request = 700;
        } else if (strtolower($paket) == 'lite') {
            $limit_request = 250; // Example for 'lite'
        } else {
            $limit_request = 200; // Default for other packages
        }

        // Calculate the remaining requests
        $tersisa = $limit_request - $terpakai;

    } else {
        // Set an error message if API calls fail
        $error_message = "Gagal mengambil data. Pastikan API Key Anda benar dan server bisa terhubung ke API.";
    }
}

// Get Server IP, fallback for local development
$whitelist_ip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : '127.0.0.1';

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cek Limit Penggunaan API</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
            margin: 0;
            padding-top: 20px;
        }
        .container {
            width: 100%;
            max-width: 450px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 25px;
            box-sizing: border-box;
        }
        h2 {
            text-align: center;
            color: #1a2c4e;
            font-weight: 500;
            margin-top: 0;
            margin-bottom: 25px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
            font-size: 14px;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }
        .ip-display {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #f7f7f7;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }
        #ip-address {
            font-weight: bold;
            color: #0056b3;
        }
        .copy-btn {
            background: none;
            border: 1px solid #007bff;
            color: #007bff;
            padding: 5px 10px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 500;
        }
        .copy-btn:hover {
            background-color: #007bff;
            color: white;
        }
        .submit-btn {
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 10px;
        }
        .submit-btn:hover {
            background-color: #0056b3;
        }
        .result-box {
            margin-top: 25px;
            border: 1px solid #28a745;
            border-radius: 8px;
            padding: 20px;
            background-color: #f8fdf9;
        }
        .result-header {
            text-align: center;
            margin-bottom: 20px;
        }
        .result-header img {
            width: 50px;
            height: 50px;
        }
        .result-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
            font-size: 15px;
        }
        .result-item:last-child {
            border-bottom: none;
        }
        .result-item span:first-child {
            color: #6c757d;
        }
        .result-item span:last-child {
            font-weight: bold;
            color: #343a40;
        }
        .error {
            background-color: #f8d7da;
            color: #721c24;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
            margin-top: 20px;
        }
    </style>
</head>
<body>

    <div class="container">
        <h2>Cek Limit Penggunaan API</h2>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="api_key">API Key Anda</label>
                <input type="text" id="api_key" name="api_key" placeholder="Masukkan API KEY Anda..." required>
            </div>

            <div class="form-group">
                 <label>Whitelist IP</label>
                 <div class="ip-display">
                    <span id="ip-address"><?= htmlspecialchars($whitelist_ip) ?></span>
                    <button type="button" class="copy-btn" onclick="copyIP()">Salin</button>
                 </div>
            </div>
            
            <button type="submit" class="submit-btn">Cek Sekarang</button>
        </form>
        
        <?php if ($error_message): ?>
            <div class="error"><?= $error_message ?></div>
        <?php endif; ?>

        <?php if ($nama_aplikasi): // Show result box only if data is successfully fetched ?>
        <div class="result-box">
            <div class="result-header">
                <img src="<?=$img?>" alt="Logo Aplikasi">
            </div>
            <div class="result-item">
                <span>Nama Aplikasi</span>
                <span><?= $nama_aplikasi ?></span>
            </div>
            <div class="result-item">
                <span>Paket</span>
                <span><?= $paket ?></span>
            </div>
            <div class="result-item">
                <span>Masa Aktif</span>
                <span><?= $masa_aktif ?></span>
            </div>
            <div class="result-item">
                <span>Limit Request</span>
                <span><?= number_format($limit_request) ?></span>
            </div>
            <div class="result-item">
                <span>Terpakai</span>
                <span><?= number_format($terpakai) ?></span>
            </div>
            <div class="result-item">
                <span>Tersisa</span>
                <span><?= number_format($tersisa) ?></span>
            </div>
        </div>
        <?php endif; ?>

    </div>

    <script>
        function copyIP() {
            // Get the text from the span
            const ipText = document.getElementById('ip-address').innerText;

            // Use the modern Navigator Clipboard API
            navigator.clipboard.writeText(ipText).then(function() {
                // Success feedback
                alert('IP berhasil disalin: ' + ipText);
            }, function(err) {
                // Error feedback
                alert('Gagal menyalin IP. Coba salin manual.');
                console.error('Could not copy text: ', err);
            });
        }
    </script>

</body>
</html>
