<?php
// File ini dirancang untuk dijalankan oleh server (Cron Job), bukan oleh pengguna.

// Memanggil file konfigurasi untuk koneksi database.
require_once __DIR__ . '/config.php';

echo "Memulai proses reset akun yang sudah kedaluwarsa (berdasarkan waktu)...\n";

// ===================================================================
// --- PERUBAHAN UTAMA DI SINI ---
// ===================================================================
// Query ini sekarang menggunakan NOW() untuk membandingkan tanggal dan waktu.
// Ia akan mencari semua pengguna yang:
// 1. Memiliki `status_aktif` (tidak NULL).
// 2. Waktu `status_aktif`-nya sudah lewat dari waktu saat ini (NOW()).
// 3. Status `jenis_akun`-nya BUKAN 'no'.
$sql = "UPDATE users 
        SET 
            limit_api = 0, 
            jenis_akun = 'no', 
            status_aktif = NULL 
        WHERE 
            status_aktif IS NOT NULL 
            AND status_aktif < NOW() 
            AND jenis_akun != 'no'";
// ===================================================================

// Eksekusi query
if ($conn->query($sql) === TRUE) {
    // Dapatkan jumlah baris (akun) yang berhasil diupdate
    $affected_rows = $conn->affected_rows;
    echo "Proses selesai. Jumlah akun yang direset: " . $affected_rows . "\n";
} else {
    // Jika ada error, catat atau tampilkan
    echo "Error saat mengupdate data: " . $conn->error . "\n";
}

// Tutup koneksi database
$conn->close();
?>
