<?php
// Ganti dengan path config database Anda
require_once 'config.php'; 

// --- PENGATURAN KEAMANAN ---
// Tentukan kata sandi untuk menjalankan skrip ini. Ganti dengan password yang kuat!
define('MASTER_PASSWORD', 'herikurni');
// ----------------------------

$error_message = '';
$success_message = '';

// Cek jika form telah disubmit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $input_password = $_POST['master_password'] ?? '';
    $confirm_check = isset($_POST['confirm_deletion']);
    $protected_usernames_str = $_POST['protected_usernames'] ?? '';

    // Validasi 1: Konfirmasi harus dicentang
    if (!$confirm_check) {
        $error_message = "Anda harus mencentang kotak konfirmasi untuk melanjutkan.";
    // Validasi 2: Password harus benar
    } elseif ($input_password !== MASTER_PASSWORD) {
        $error_message = "Kata sandi utama salah! Proses dibatalkan.";
    // Validasi 3: Input username tidak boleh kosong
    } elseif (empty(trim($protected_usernames_str))) {
        $error_message = "Anda harus memasukkan minimal satu username untuk dilindungi.";
    } else {
        // Proses daftar username yang dilindungi
        // 1. Pisahkan string berdasarkan koma menjadi array
        $protected_users = explode(',', $protected_usernames_str);
        // 2. Hapus spasi ekstra dari setiap username
        $protected_users = array_map('trim', $protected_users);
        // 3. Hapus entri kosong jika ada (misal: "budi, , rudi")
        $protected_users = array_filter($protected_users);

        // Jika setelah diproses arraynya kosong, batalkan
        if (empty($protected_users)) {
             $error_message = "Daftar username yang dilindungi tidak valid.";
        } else {
            try {
                // Buat placeholder (?) sebanyak jumlah username yang dilindungi
                $placeholders = implode(',', array_fill(0, count($protected_users), '?'));
                
                // Siapkan statement DELETE dengan klausa "NOT IN"
                $stmt = $conn->prepare("DELETE FROM users WHERE username NOT IN ($placeholders)");
                
                // Tentukan tipe data untuk bind_param ('s' untuk string)
                $types = str_repeat('s', count($protected_users));
                
                // Bind semua username yang dilindungi ke statement
                $stmt->bind_param($types, ...$protected_users);
                
                // Eksekusi query
                $stmt->execute();
                
                $deleted_count = $stmt->affected_rows;
                $success_message = "Proses selesai! Sebanyak **" . $deleted_count . " akun** telah berhasil dihapus. Akun yang dilindungi: " . htmlspecialchars(implode(', ', $protected_users));
                
                $stmt->close();
            } catch (Exception $e) {
                $error_message = "Terjadi kesalahan database: " . $e->getMessage();
            }
        }
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hapus Akun Selektif</title>
    <style>
        body { font-family: sans-serif; display: flex; justify-content: center; align-items: center; min-height: 100vh; background-color: #fbecec; padding: 20px 0; }
        .container { width: 600px; padding: 2rem; background: #fff; border: 2px solid #dc3545; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
        h2 { color: #dc3545; text-align: center; }
        .warning { background-color: #f8d7da; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem; text-align: center; }
        .form-group { margin-bottom: 1.5rem; }
        label { display: block; margin-bottom: 0.5rem; font-weight: bold; }
        input[type="password"], textarea { padding: 0.5rem; width: 100%; box-sizing: border-box; border: 1px solid #ccc; border-radius: 4px; font-family: sans-serif; }
        textarea { resize: vertical; min-height: 80px; }
        button { width: 100%; padding: 0.8rem; color: #fff; background-color: #dc3545; border: none; border-radius: 4px; cursor: pointer; font-size: 1rem; font-weight: bold; }
        button:hover { background-color: #c82333; }
        .message { margin-top: 1rem; padding: 0.7rem; border-radius: 4px; text-align: center; word-wrap: break-word; }
        .message.error { color: #721c24; background-color: #f8d7da; }
        .message.success { color: #155724; background-color: #d4edda; }
        .checkbox-label { display: flex; align-items: center; font-weight: normal; }
        .checkbox-label input { margin-right: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>HAPUS AKUN SELEKTIF</h2>
        <div class="warning">
            <strong>PERHATIAN!</strong> Skrip ini akan menghapus SEMUA akun kecuali yang username-nya Anda masukkan di bawah. Pastikan tidak ada salah ketik.
        </div>

        <?php if ($error_message): ?>
            <div class="message error"><?= htmlspecialchars($error_message, ENT_QUOTES, 'UTF-8'); ?></div>
        <?php endif; ?>
        <?php if ($success_message): ?>
            <div class="message success"><?= $success_message; ?></div>
        <?php endif; ?>

        <form action="" method="post">
            <div class="form-group">
                <label for="protected_usernames">Username yang TIDAK akan dihapus (pisahkan dengan koma):</label>
                <textarea id="protected_usernames" name="protected_usernames" placeholder="Contoh: budi, rudi, admin01" required></textarea>
            </div>
            <div class="form-group">
                <label for="master_password">Masukkan Kata Sandi Utama:</label>
                <input type="password" id="master_password" name="master_password" required>
            </div>
            <div class="form-group">
                <label class="checkbox-label">
                    <input type="checkbox" name="confirm_deletion" required>
                    Saya mengerti dan yakin ingin menghapus semua akun yang tidak terdaftar di atas.
                </label>
            </div>
            <button type="submit">HAPUS AKUN LAINNYA SEKARANG</button>
        </form>
    </div>
</body>
</html>
