<?php
// 1. PENGATURAN & AUTENTIKASI
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once 'config.php';

if (!isset($_SESSION['username'])) {
    header("Location: /login");
    exit();
}
$username = $_SESSION['username'];

// 2. AMBIL DATA PENGGUNA
$stmt = $conn->prepare("SELECT * FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    session_destroy();
    header("Location: /login");
    exit();
}
$masa_aktif_timestamp = strtotime($user['masa_aktif']);
$sekarang_timestamp = time();

$sisa_hari = 0; // Nilai default jika sudah expired

// Cek apakah masa aktif masih di masa depan
if ($masa_aktif_timestamp > $sekarang_timestamp) {
    // Hitung selisih waktu dalam detik
    $selisih_detik = $masa_aktif_timestamp - $sekarang_timestamp;
    // Konversi detik menjadi hari, lalu bulatkan ke atas dengan ceil()
    $sisa_hari = ceil($selisih_detik / (60 * 60 * 24));
}

// Tentukan status expired berdasarkan sisa hari
// 4. MEMANGGIL TAMPILAN
$page_title = "Dashboard";
require_once 'menu/header.php';
?>

<div class="container">
    <main>
        <div class="info-grid">
            <div class="card">
              <p class="label">Premium</p>
              <p class="value"><?php echo htmlspecialchars($user['premium']); ?></p>
            </div>
            <div class="card">
              <p class="label">Masa Aktif</p>
              <p class="value"><?php echo $sisa_hari; ?> Hari</p>
            </div>
            <div class="card">
              <p class="label">Hit Hari Ini</p>
              <p class="value"><?php echo htmlspecialchars(ucfirst($user['hit_hari_ini'])); ?></p>
            </div>
            <div class="card">
                <p class="label">Total Hit</p>
                <p class="value"><?php echo htmlspecialchars($user['total_hit']); ?></p>
            </div>
            <div class="card">
                <p class="label">Saldo</p>
                <p class="value saldo">Rp<?php echo number_format($user['saldo'], 0, ',', '.'); ?></p>
            </div>
            <div class="card">
                <p class="label">Limit</p>
                <p class="value saldo">
                    <?php echo htmlspecialchars($user['limit_api']); ?>/hari
                </p>
            </div>
            <!--div class="card">
                <p class="label">Expired</p>
                <p class="value">
                    <?php 
                    // Logika tampilan diubah agar lebih konsisten
                    if ($user['jenis_akun'] == 'no' || empty($user['status_aktif'])) {
                        echo '-';
                    } else {
                        echo $status_aktif_formatted; 
                    }
                    ?>
                </p>
            </div-->
        </div>

        <div class="apikey-section text-bg-primary">
          <p class="label text-center text-white">Apikeymu</p>
            <div class="apikey-display text-bg-white" id="apiKey"><?php echo htmlspecialchars($user['apikey']); ?></div>
            <div class="d-flex">
            <button class="btn copy-button" id="copyButton">
                <svg xmlns="http://www.w3.org/2000/svg" width="13" height="13" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z"/><path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"/><path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"/></svg>
                Salin Apikey
            </button>
            </div>
        </div>
    </main>
</div>
<?php
// 5. TUTUP KONEKSI & MEMANGGIL FOOTER
require_once 'menu/footer.php';
$conn->close();
?>
