<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Cek apakah pengguna sudah login
if (!isset($_SESSION['username'])) {
    header("Location: /login"); // Ganti dengan halaman login Anda
    exit();
}

require_once '../config.php'; // Hubungkan ke database

$username = $_SESSION['username'];
$action = $_GET['action'] ?? 'detail'; // Default action adalah 'detail'

// --- LOGIKA PEMROSESAN FORM (JIKA ADA) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_account'])) {
    $email = $_POST['email'];
    $nomor = $_POST['nomor'];
    $new_password = $_POST['new_password'];
    $current_password = $_POST['current_password'];

    // 1. Ambil data user untuk verifikasi password lama
    $stmt_verify = $conn->prepare("SELECT password FROM users WHERE username = ?");
    $stmt_verify->bind_param("s", $username);
    $stmt_verify->execute();
    $user_verify = $stmt_verify->get_result()->fetch_assoc();
    $stmt_verify->close();

    // 2. Validasi password saat ini
    if (!$user_verify || !password_verify($current_password, $user_verify['password'])) {
        $_SESSION['update_error'] = "Password saat ini yang Anda masukkan salah.";
        header("Location: akun?action=edit");
        exit();
    }

    // 3. Siapkan query update
    $sql_parts = ["email = ?", "nomor = ?"];
    $params = [$email, $nomor];
    $types = 'ss';

    // Jika password baru diisi
    if (!empty($new_password)) {
        if ($new_password !== $_POST['confirm_new_password']) {
            $_SESSION['update_error'] = "Konfirmasi password baru tidak cocok.";
            header("Location: akun?action=edit");
            exit();
        }
        $hashed_new_password = password_hash($new_password, PASSWORD_DEFAULT);
        $sql_parts[] = "password = ?";
        $params[] = $hashed_new_password;
        $types .= 's';
    }

    $params[] = $username;
    $types .= 's';

    // 4. Eksekusi query
    $sql = "UPDATE users SET " . implode(', ', $sql_parts) . " WHERE username = ?";
    $stmt_update = $conn->prepare($sql);
    $stmt_update->bind_param($types, ...$params);

    if ($stmt_update->execute()) {
        $_SESSION['update_success'] = "Detail akun berhasil diperbarui.";
    } else {
        $_SESSION['update_error'] = "Gagal memperbarui data. Silakan coba lagi.";
    }
    $stmt_update->close();
    header("Location: akun"); // Redirect kembali ke halaman detail
    exit();
}


// --- PENGAMBILAN DATA UNTUK TAMPILAN ---
$stmt = $conn->prepare("SELECT username, email, role, nomor, apikey FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();
$conn->close();

if (!$user) {
    die("Error: Data pengguna tidak ditemukan.");
}

// Tentukan judul halaman berdasarkan aksi
$page_title = ($action === 'edit') ? "Edit Akun" : "Detail Akun";

// Panggil header
require_once 'header.php';
?>

<div class="container">
    <main>
        <h1 class="page-title"><?php echo htmlspecialchars($page_title); ?></h1>

        <?php if (isset($_SESSION['update_success'])): ?>
            <div class="alert alert-success" role="alert">
                <?php echo $_SESSION['update_success']; unset($_SESSION['update_success']); ?>
            </div>
        <?php endif; ?>
        <?php if (isset($_SESSION['update_error'])): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $_SESSION['update_error']; unset($_SESSION['update_error']); ?>
            </div>
        <?php endif; ?>

        <?php if ($action === 'edit'): ?>
            <div class="form-container">
                <form action="akun" method="POST" id="editAccountForm">
                    <input type="hidden" name="update_account" value="1">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email" class="form-control" value="<?php echo htmlspecialchars($user['email']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="nomor">Nomor Telepon</label>
                        <input type="tel" id="nomor" name="nomor" class="form-control" value="<?php echo htmlspecialchars($user['nomor'] ?? ''); ?>" placeholder="Contoh: 08123456789">
                    </div>

                    <hr class="form-divider">
                    <p class="form-note">Isi bagian di bawah ini hanya jika Anda ingin mengubah password.</p>

                    <div class="form-group">
                        <label for="new_password">Password Baru (Opsional)</label>
                        <input type="password" id="new_password" name="new_password" class="form-control">
                    </div>

                    <div class="form-group">
                        <label for="confirm_new_password">Konfirmasi Password Baru</label>
                        <input type="password" id="confirm_new_password" name="confirm_new_password" class="form-control">
                    </div>

                    <hr class="form-divider">
                    <p class="form-note">Masukkan password Anda saat ini untuk menyimpan perubahan.</p>
                    
                    <div class="form-group">
                        <label for="current_password">Password Saat Ini (Wajib)</label>
                        <input type="password" id="current_password" name="current_password" class="form-control" required>
                    </div>

                    <button type="submit" class="submit-button">Simpan Perubahan</button>
                    <a href="akun" class="cancel-button">Batal</a>
                </form>
            </div>
            <script>
            document.getElementById('editAccountForm').addEventListener('submit', function(event) {
                const newPassword = document.getElementById('new_password').value;
                const confirmPassword = document.getElementById('confirm_new_password').value;
                if (newPassword !== '' && newPassword !== confirmPassword) {
                    alert('Konfirmasi password baru tidak cocok!');
                    event.preventDefault();
                }
            });
            </script>

        <?php else: ?>
            <div class="account-details-card">
                <div class="detail-item">
                    <span class="label">Username</span>
                    <span class="value"><?php echo htmlspecialchars($user['username']); ?></span>
                </div>
                <hr>
                <div class="detail-item">
                    <span class="label">Email</span>
                    <span class="value"><?php echo htmlspecialchars($user['email']); ?></span>
                </div>
                <hr>
                <div class="detail-item">
                    <span class="label">Nomor Telepon</span>
                    <span class="value"><?php echo htmlspecialchars($user['nomor'] ?? 'Belum diatur'); ?></span>
                </div>
                <hr>
                <div class="detail-item">
                    <span class="label">Role</span>
                    <span class="value"><?php echo htmlspecialchars(ucfirst($user['role'])); ?></span>
                </div>
                <hr>
                <div class="apikey-section">
                    <div class="label">API Key Anda</div>
                    <div class="apikey-display">
                        <span id="apiKey"><?php echo htmlspecialchars($user['apikey']); ?></span>
                    </div>
                    <button class="copy-button" onclick="copyApiKey()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M4 1.5H3a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-8a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1v-8a1 1 0 0 1 1-1h1z"/><path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0z"/></svg>
                        Salin API Key
                    </button>
                </div>
                <a href="akun?action=edit" class="edit-button">Edit Akun</a>
            </div>
            <script>
            function copyApiKey() {
                const apiKeyText = document.getElementById('apiKey').innerText;
                navigator.clipboard.writeText(apiKeyText).then(function() {
                    alert('API Key berhasil disalin!');
                }, function(err) {
                    alert('Gagal menyalin API Key.');
                });
            }
            </script>

        <?php endif; ?>
    </main>
</div>

<?php
// Panggil footer
require_once 'footer.php';
?>
