<?php
// File ini dirancang untuk dijalankan oleh server (Cron Job)

require_once __DIR__ . '/../config.php'; // Sesuaikan path ke config.php

// Atur zona waktu agar konsisten
date_default_timezone_set('Asia/Jakarta');

echo "[" . date('Y-m-d H:i:s') . "] Memulai pengecekan deposit...\n";

// 1. Ambil SEMUA deposit yang statusnya 'Pending' dari database
//======================================================================
/*$sql_pending = "SELECT id_depo, gateway_id, username, nominal FROM deposits WHERE status = 'Pending'";*/
$sql_pending = "SELECT id_depo, gateway_id, username, nominal, status 
                FROM deposits 
                WHERE status IN ('Pending', 'Success')";
$result_pending = $conn->query($sql_pending);
$pending_deposits = [];
if ($result_pending->num_rows > 0) {
    while ($row = $result_pending->fetch_assoc()) {
        $pending_deposits[] = $row;
    }
}

if (empty($pending_deposits)) {
    echo "Tidak ada deposit pending untuk diperiksa. Proses selesai.\n";
    $conn->close();
    exit;
}

echo "Ditemukan " . count($pending_deposits) . " deposit pending. Memeriksa satu per satu...\n";

// 2. Ambil konfigurasi gateway (hanya sekali)
//======================================================================
$stmt_gw = $conn->prepare("SELECT url, apikey FROM payment_setting WHERE nama = 'atlantich2h'");
$stmt_gw->execute();
$gateway_config = $stmt_gw->get_result()->fetch_assoc();
$stmt_gw->close();

if (!$gateway_config) {
    die("Error: Konfigurasi gateway 'atlantich2h' tidak ditemukan.\n");
}

$api_url_status = rtrim($gateway_config['url'], '/') . '/deposit/status';
$api_key = $gateway_config['apikey'];
$berhasil = 0;
$gagal = 0;
$kedaluwarsa = 0;

// 3. Looping melalui setiap deposit pending dan cek statusnya
//======================================================================
foreach ($pending_deposits as $deposit) {
    
    $post_data_status = http_build_query(['api_key' => $api_key, 'id' => $deposit['gateway_id']]);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $api_url_status,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $post_data_status,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 15
    ]);
    $response_body = curl_exec($ch);
    curl_close($ch);
    $response_data = json_decode($response_body, true);

    if (isset($response_data['status']) && $response_data['status'] == true && isset($response_data['data']['status'])) {
        $gateway_status = $response_data['data']['status'];

        /*switch ($gateway_status) {
            case 'processing':
            case 'success':
                // Jika sukses, tambahkan saldo dan update status
                $conn->begin_transaction();
                try {
                    $stmt_update_deposit = $conn->prepare("UPDATE deposits SET status = 'Success' WHERE id_depo = ?");
                    $stmt_update_deposit->bind_param("s", $deposit['id_depo']);
                    $stmt_update_deposit->execute();

                    $stmt_update_user = $conn->prepare("UPDATE users SET saldo = saldo + ? WHERE username = ?");
                    $stmt_update_user->bind_param("is", $deposit['nominal'], $deposit['username']);
                    $stmt_update_user->execute();
                    
                    $conn->commit();
                    echo " -> Deposit " . $deposit['id_depo'] . " SUKSES. Limit ditambahkan.\n";
                    $berhasil++;
                } catch (mysqli_sql_exception $exception) {
                    $conn->rollback();
                    echo " -> GAGAL memproses deposit " . $deposit['id_depo'] . " karena error database.\n";
                    $gagal++;
                }
                break;

            case 'expired':
            case 'cancel':
                // Jika expired atau cancel, cukup update status
                $new_status = ($gateway_status == 'expired') ? 'Expired' : 'Cancelled';
                $stmt_expire = $conn->prepare("UPDATE deposits SET status = ? WHERE id_depo = ?");
                $stmt_expire->bind_param("ss", $new_status, $deposit['id_depo']);
                $stmt_expire->execute();
                echo " -> Deposit " . $deposit['id_depo'] . " statusnya " . $new_status . ".\n";
                $kedaluwarsa++;
                break;
        }*/
        switch ($gateway_status) {
            case 'success':
                // Tambahkan saldo hanya jika deposit masih Pending
                $conn->begin_transaction();
                try {
                    // Update status deposit jadi Success
                    $stmt_update_deposit = $conn->prepare("UPDATE deposits SET status = 'Success' WHERE id_depo = ? AND status = 'Pending'");
                    $stmt_update_deposit->bind_param("s", $deposit['id_depo']);
                    $stmt_update_deposit->execute();
        
                    // Cek apakah ada row yang berubah (berarti status dari Pending -> Success)
                    if ($stmt_update_deposit->affected_rows > 0) {
                        // Tambahkan saldo user
                        $stmt_update_user = $conn->prepare("UPDATE users SET saldo = saldo + ? WHERE username = ?");
                        $stmt_update_user->bind_param("is", $deposit['nominal'], $deposit['username']);
                        $stmt_update_user->execute();
        
                        echo " -> Deposit " . $deposit['id_depo'] . " SUKSES. Saldo user " . $deposit['username'] . " ditambahkan " . $deposit['nominal'] . ".\n";
                        $berhasil++;
                    } else {
                        echo " -> Deposit " . $deposit['id_depo'] . " sudah pernah diproses.\n";
                    }
        
                    $conn->commit();
                } catch (mysqli_sql_exception $exception) {
                    $conn->rollback();
                    echo " -> GAGAL memproses deposit " . $deposit['id_depo'] . " karena error database.\n";
                    $gagal++;
                }
                break;
        
            case 'processing':
                echo " -> Deposit " . $deposit['id_depo'] . " masih processing.\n";
                break;
        
            case 'expired':
            case 'cancel':
                // Jika expired atau cancel, cukup update status
                $new_status = ($gateway_status == 'expired') ? 'Expired' : 'Cancelled';
                $stmt_expire = $conn->prepare("UPDATE deposits SET status = ? WHERE id_depo = ?");
                $stmt_expire->bind_param("ss", $new_status, $deposit['id_depo']);
                $stmt_expire->execute();
                echo " -> Deposit " . $deposit['id_depo'] . " statusnya " . $new_status . ".\n";
                $kedaluwarsa++;
                break;
        }
    }
}

echo "Pengecekan selesai. Hasil: Sukses(" . $berhasil . "), Gagal(" . $gagal . "), Kedaluwarsa/Batal(" . $kedaluwarsa . ").\n";
$conn->close();
?>
