<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// ## TAMBAHKAN BLOK INI ##
// Cek apakah pengguna sudah login. Jika belum, arahkan ke halaman login.
if (!isset($_SESSION['username'])) {
    header("Location: /login"); // Ganti dengan halaman login Anda
    exit();
}

// #########################

// 1. Hubungkan ke file setting untuk mengambil data kontak
require_once '../config.php'; // Hubungkan ke database
require_once '../setting.php'; 

// Panggil header utama website Anda
require_once 'header.php'; 

$page_title = "Hubungi Kami";
?>

<div class="container">
    <main>
        <h1 class="page-title"><?php echo htmlspecialchars($page_title); ?></h1>

        <div class="contact-list">
            <a href="mailto:<?php echo $contact_email; ?>" class="contact-item email">
                <div class="contact-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor" viewBox="0 0 16 16"><path d="M.05 3.555A2 2 0 0 1 2 2h12a2 2 0 0 1 1.95 1.555L8 8.414zM0 4.697v7.104l5.803-3.558zM6.761 8.83l-6.57 4.027A2 2 0 0 0 2 14h12a2 2 0 0 0 1.808-1.144l-6.57-4.027L8 9.586zm3.436-.586L16 11.801V4.697z"/></svg>
                </div>
                <div class="contact-details">
                    <span class="contact-title">Email</span>
                    <span class="contact-value"><?php echo $contact_email; ?></span>
                </div>
            </a>

            <a href="https://wa.me/<?php echo $contact_whatsapp; ?>" target="_blank" class="contact-item whatsapp">
                <div class="contact-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor" viewBox="0 0 16 16"><path d="M13.601 2.326A7.85 7.85 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.9 7.9 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.9 7.9 0 0 0 13.6 2.326zM7.994 14.521a6.6 6.6 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.56 6.56 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592m3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.73.73 0 0 0-.529.247c-.182.198-.691.677-.691 1.654s.71 1.916.81 2.049c.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232"/></svg>
                </div>
                <div class="contact-details">
                    <span class="contact-title">WhatsApp</span>
                    <span class="contact-value">+<?php echo $contact_whatsapp; ?></span>
                </div>
            </a>

            <a href="https://t.me/<?php echo $contact_telegram; ?>" target="_blank" class="contact-item telegram">
                <div class="contact-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor" viewBox="0 0 16 16"><path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.287 5.906c-.778.324-2.334.994-4.666 2.01-.378.15-.577.298-.595.442-.03.243.275.339.69.47l.175.055c.408.133.958.288 1.243.294.26.006.549-.1.868-.32 2.179-1.471 3.304-2.214 3.374-2.23.05-.012.12-.026.166.016.047.041.042.12.037.141-.03.129-1.227 1.241-1.846 1.817-.193.18-.33.307-.358.336a8 8 0 0 1-.188.186c-.38.366-.664.64.015 1.088.327.216.589.393.85.571.284.194.568.387.936.629.093.06.183.125.27.187.331.236.63.448.997.414.214-.02.435-.22.547-.82.265-1.417.786-4.486.906-5.162.015-.09.037-.176.02-.248a.5.5 0 0 0-.12-.244.5.5 0 0 0-.258-.079c-.34.02-.733.244-1.14.495z"/></svg>
                </div>
                <div class="contact-details">
                    <span class="contact-title">Telegram</span>
                    <span class="contact-value">@<?php echo $contact_telegram; ?></span>
                </div>
            </a>
        </div>
    </main>
</div>

<?php
// Panggil footer utama website Anda
require_once 'footer.php';
?>
