<?php
// 1. MULAI SESI DAN CEK LOGIN
// ===================================
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Hubungkan ke database
require_once '../config.php'; // Pastikan path ini benar

// Cek apakah pengguna sudah login, jika tidak, tendang ke halaman login
if (!isset($_SESSION['username'])) {
    header("Location: /login"); // Arahkan ke file login.php
    exit();
}

// 2. AMBIL DATA PENGGUNA DAN DATA LAIN
// ===================================
$username = $_SESSION['username'];

// Ambil data lengkap pengguna
$stmt_user = $conn->prepare("SELECT * FROM users WHERE username = ?"); 
$stmt_user->bind_param("s", $username); 
$stmt_user->execute();
$result_user = $stmt_user->get_result();
$user = $result_user->fetch_assoc();
$stmt_user->close();

// Jika user tidak ditemukan di database (misal sudah dihapus), hancurkan sesi
if (!$user) {
    session_destroy();
    header("Location: /login.php");
    exit();
}

$conn->close();

// Set judul halaman
$page_title = "Dokumentasi API";


// 3. TAMPILKAN HALAMAN
// ===================================
// Panggil header, yang akan menampilkan informasi pengguna
require_once 'header.php';
?>

<div id="swagger-ui"></div>

<?php
// Panggil footer untuk menutup halaman dan memuat script JS
require_once 'footer.php';
?>
