    <script src="../assets/script.js"></script>
  <script src="https://unpkg.com/swagger-ui-dist@5/swagger-ui-bundle.js" charset="UTF-8"></script>
  <script src="https://imgup1.statuspage.io/embed/script.js"></script>
  <script>
    window.onload = function() {
      // Build a system
      const ui = SwaggerUIBundle({
        url: 'openapi.yaml',
        dom_id: '#swagger-ui',
        presets: [
          SwaggerUIBundle.presets.apis,
          SwaggerUIBundle.SwaggerUIStandalonePreset
        ],
        layout: "BaseLayout"
      });
      window.ui = ui;
    };
  </script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const modal = document.getElementById('paymentModal');
    const closeButton = document.querySelector('.close-button');
    const orderButtons = document.querySelectorAll('.order-button');
    const userBalance = parseFloat(<?php echo $user['saldo']; ?>);
    const purchaseForm = document.getElementById('purchase-form');
    const notification = document.getElementById('notification');

    orderButtons.forEach(button => {
        button.addEventListener('click', function () {
            const paketId = this.dataset.id;
            const namaPaket = this.dataset.nama;
            const hargaPaket = parseFloat(this.dataset.harga);
            const sisaSaldo = userBalance - hargaPaket;

            document.getElementById('modal-packname').textContent = namaPaket;
            document.getElementById('modal-price').textContent = `Rp ${hargaPaket.toLocaleString('id-ID')}`;
            document.getElementById('modal-paket-id').value = paketId;

            const remainingBalanceEl = document.getElementById('modal-remaining-balance');
            remainingBalanceEl.textContent = `Rp ${sisaSaldo.toLocaleString('id-ID')}`;
            
            const confirmBtn = document.getElementById('confirm-payment-button');

            if (sisaSaldo < 0) {
                remainingBalanceEl.style.color = 'var(--danger-color)';
                confirmBtn.disabled = true;
                confirmBtn.innerHTML = '<span class="button-text">Saldo Tidak Cukup</span>';
                confirmBtn.style.backgroundColor = '#ccc';
            } else {
                remainingBalanceEl.style.color = 'var(--success-color)';
                confirmBtn.disabled = false;
                confirmBtn.innerHTML = '<span class="button-text">Bayar Sekarang</span><span class="button-loader" style="display: none;">Memproses...</span>';
                confirmBtn.style.backgroundColor = '';
            }
            modal.style.display = 'flex';
        });
    });

    closeButton.addEventListener('click', () => modal.style.display = 'none');
    window.addEventListener('click', (event) => {
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    });

    purchaseForm.addEventListener('submit', function (e) {
        e.preventDefault();
        const button = this.querySelector('button[type="submit"]');
        const buttonText = button.querySelector('.button-text');
        const buttonLoader = button.querySelector('.button-loader');

        buttonText.style.display = 'none';
        buttonLoader.style.display = 'inline-block';
        button.disabled = true;

        const formData = new FormData(this);

        // ===============================================
        // --- PERBAIKAN UTAMA DI SINI ---
        // ===============================================
        fetch('', { // URL dikosongkan agar mengirim ke halaman saat ini
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            modal.style.display = 'none';
            notification.textContent = data.message;
            notification.className = data.success ? 'notification success' : 'notification error';
            notification.style.display = 'block';

            if (data.success) {
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            } else {
                buttonText.style.display = 'inline-block';
                buttonLoader.style.display = 'none';
                button.disabled = false;
                 setTimeout(() => {
                    notification.style.display = 'none';
                }, 3000);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            notification.textContent = 'Terjadi kesalahan jaringan. Coba lagi.';
            notification.className = 'notification error';
            notification.style.display = 'block';
        });
    });
});
</script>
</body>
</html>
