<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once '../config.php';

if (!isset($_SESSION['username'])) {
    header("Location: /login");
    exit();
}

$username = $_SESSION['username'];

// Ambil data user
$user_query = $conn->prepare("SELECT * FROM users WHERE username = ?");
$user_query->bind_param("s", $username);
$user_query->execute();
$user = $user_query->get_result()->fetch_assoc();
$user_id = $user['id'];
$user_saldo = $user['saldo'];
$masa_aktif_user = $user['masa_aktif'];
$limit_api_user = $user['limit_api'];

// Proses pembelian jika form disubmit
$invoice = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['paket_id'], $_POST['bulan'])) {
    $paket_id = intval($_POST['paket_id']);
    $bulan = intval($_POST['bulan']);

    // Ambil paket
    $paket = $conn->prepare("SELECT * FROM paket_harga WHERE id = ?");
    $paket->bind_param("i", $paket_id);
    $paket->execute();
    $paket_data = $paket->get_result()->fetch_assoc();

    if ($paket_data) {
        $nama_paket = $paket_data['nama_paket'];
        $harga_per_bulan = $paket_data['harga'];
        $limit_api_paket = $paket_data['limit_api'];
        $masa_aktif_per_bulan = $paket_data['masa_aktif_hari'];
        $total_harga = $harga_per_bulan * $bulan;
        $total_hari = $masa_aktif_per_bulan * $bulan;

        if ($user_saldo >= $total_harga) {
            // Kurangi saldo
            $new_saldo = $user_saldo - $total_harga;

            // Hitung masa aktif baru
            $now = date('Y-m-d');
            $masa_aktif_baru = (strtotime($masa_aktif_user) > time())
                ? date('Y-m-d', strtotime($masa_aktif_user . " +$total_hari days"))
                : date('Y-m-d', strtotime($now . " +$total_hari days"));

            // Ganti limit API sesuai paket yang dipilih (bukan ditambah)
            $limit_api_baru = $limit_api_paket;
            $premium = "yes";
            // Update saldo, masa aktif, limit API
            $update = $conn->prepare("UPDATE users SET saldo = ?, masa_aktif = ?, limit_api = ?, premium = ? WHERE id = ?");
            $update->bind_param("dsisi", $new_saldo, $masa_aktif_baru, $limit_api_baru, $premium, $user_id);
            $update->execute();

            // Buat invoice
            $metode = "Saldo";
            $tanggal = date('Y-m-d H:i:s');
            $conn->query("INSERT INTO invoice (user_id, paket, harga_per_bulan, jumlah_bulan, total, metode, tanggal)
                          VALUES ($user_id, '$nama_paket', $harga_per_bulan, $bulan, $total_harga, '$metode', '$tanggal')");
            $invoice_id = $conn->insert_id;

            // Ambil invoice untuk ditampilkan
            $invoice = [
                'id' => $invoice_id,
                'paket' => $nama_paket,
                'harga_per_bulan' => $harga_per_bulan,
                'jumlah_bulan' => $bulan,
                'total' => $total_harga,
                'metode' => $metode,
                'tanggal' => $tanggal,
                'masa_aktif_baru' => $masa_aktif_baru,
                'limit_api_baru' => $limit_api_baru
            ];
            $user_saldo = $new_saldo;
        } else {
            $error = "Saldo tidak cukup untuk membeli paket ini.";
        }
    } else {
        $error = "Paket tidak ditemukan.";
    }
}

// Ambil daftar paket
$paket_list = [];
$query = $conn->query("SELECT * FROM paket_harga ORDER BY harga ASC");
while ($row = $query->fetch_assoc()) {
    $paket_list[] = [
        'id' => $row['id'],
        'nama' => $row['nama_paket'],
        'harga' => $row['harga'],
        'limit' => $row['limit_api'],
        'limit_waktu' => $row['masa_aktif_hari'] . ' Hari'
    ];
}

$page_title = "Pilih Paket";
require_once 'header.php';
?>

<div class="container my-4">
    <h4 class="text-center mb-4">Pilih Paket</h4>

    <div class="card shadow-sm p-4 mb-4">
        <h5 class="mb-3">Saldo Anda: 
            <span class="badge bg-success">
                Rp <?= number_format($user_saldo, 0, ',', '.') ?>
            </span>
        </h5>

        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <!-- Form Pembelian -->
        <form method="POST" onsubmit="return confirmPembelian()">
            <div class="row g-3">
                <div class="col-md-6">
                    <label for="paketSelect" class="form-label">Pilih Paket</label>
                    <select class="form-select" name="paket_id" id="paketSelect" required>
                        <option value="">-- Pilih Paket --</option>
                        <?php foreach ($paket_list as $paket): ?>
                            <option value="<?= $paket['id'] ?>"
                                    data-harga="<?= $paket['harga'] ?>"
                                    data-limit="<?= $paket['limit'] ?>"
                                    data-nama="<?= htmlspecialchars($paket['nama']) ?>">
                                <?= htmlspecialchars($paket['nama']) ?> 
                                (Rp <?= number_format($paket['harga'], 0, ',', '.') ?>/bulan)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-6">
                    <label for="bulanSelect" class="form-label">Durasi (Bulan)</label>
                    <select class="form-select" name="bulan" id="bulanSelect" required>
                        <option value="1">1 Bulan</option>
                        <option value="3">3 Bulan</option>
                        <option value="6">6 Bulan</option>
                        <option value="12">12 Bulan</option>
                    </select>
                </div>
            </div>

            <div class="mt-3">
                <h6>Total Pembayaran: 
                    <span class="text-primary fw-bold" id="totalHarga">Rp 0</span>
                </h6>
            </div>
            
            <div class="mt-3">
                <h6>Limit Api: 
                    <span class="text-primary fw-bold" id="limit">0</span>
                </h6>
            </div>

            <div class="mt-4 text-end">
                <button type="submit" class="btn btn-success px-4">
                    Gunakan Saldo
                </button>
            </div>
        </form>
    </div>

    <!-- Invoice (jika ada) -->
    <?php if ($invoice): ?>
        <div class="card shadow-sm p-4 mt-4 border-success">
            <h5 class="text-success mb-3">Invoice Pembelian</h5>
            <ul class="list-group list-group-flush">
                <li class="list-group-item"><strong>ID Invoice:</strong> <?= $invoice['id'] ?></li>
                <li class="list-group-item"><strong>Paket:</strong> <?= htmlspecialchars($invoice['paket']) ?></li>
                <li class="list-group-item"><strong>Harga/Bulan:</strong> Rp <?= number_format($invoice['harga_per_bulan'], 0, ',', '.') ?></li>
                <li class="list-group-item"><strong>Jumlah Bulan:</strong> <?= $invoice['jumlah_bulan'] ?> Bulan</li>
                <li class="list-group-item"><strong>Total:</strong> Rp <?= number_format($invoice['total'], 0, ',', '.') ?></li>
                <li class="list-group-item"><strong>Metode:</strong> <?= htmlspecialchars($invoice['metode']) ?></li>
                <li class="list-group-item"><strong>Tanggal:</strong> <?= $invoice['tanggal'] ?></li>
                <li class="list-group-item"><strong>Masa Aktif Baru:</strong> <?= $invoice['masa_aktif_baru'] ?></li>
                <li class="list-group-item"><strong>Limit API Baru:</strong> <?= $invoice['limit_api_baru'] ?></li>
            </ul>
        </div>
    <?php endif; ?>
</div>

<script>
const paketSelect = document.getElementById('paketSelect');
const bulanSelect = document.getElementById('bulanSelect');
const totalHargaEl = document.getElementById('totalHarga');
const limitEl = document.getElementById('limit');

function updateTotal() {
    const harga = parseInt(paketSelect.selectedOptions[0]?.getAttribute('data-harga')) || 0;
    const limit_api = parseInt(paketSelect.selectedOptions[0]?.getAttribute('data-limit')) || "unlimited";
    const bulan = parseInt(bulanSelect.value) || 1;
    totalHargaEl.textContent = `Rp ${new Intl.NumberFormat('id-ID').format(harga * bulan)}`;
    limitEl.textContent = `${limit_api}`
}

function confirmPembelian() {
    const paketOption = paketSelect.selectedOptions[0];
    const paket = paketOption?.getAttribute('data-nama') || 'Paket tidak diketahui';
    const harga = parseInt(paketOption?.getAttribute('data-harga')) || 0;
    const bulan = parseInt(bulanSelect.value) || 1;
    const total = harga * bulan;

    return confirm(`Gunakan saldo untuk membeli paket ${paket} selama ${bulan} bulan dengan harga Rp ${new Intl.NumberFormat('id-ID').format(total)}?`);
}

paketSelect.addEventListener('change', updateTotal);
bulanSelect.addEventListener('change', updateTotal);
</script>

<?php
require_once 'footer.php';
?>