<?php
// 1. PENGATURAN & AUTENTIKASI
// ===================================
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once '../config.php';

if (!isset($_SESSION['username'])) {
    header("Location: /login");
    exit();
}
$username = $_SESSION['username'];

if (!isset($_GET['reff_id'])) {
    die("Akses tidak valid. ID Referensi tidak ditemukan.");
}
$reff_id = $_GET['reff_id'];
// ==========================================================
// --- LOGIKA BARU: PROSES PEMBATALAN DEPOSIT (CANCEL) ---
// ==========================================================
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] == 'cancel') {
    
    // Ambil gateway_id dari database
    $stmt_get_id = $conn->prepare("SELECT gateway_id FROM deposits WHERE id_depo = ? AND username = ? AND status = 'Pending'");
    $stmt_get_id->bind_param("ss", $reff_id, $username);
    $stmt_get_id->execute();
    $result_id = $stmt_get_id->get_result();
    $deposit_to_cancel = $result_id->fetch_assoc();
    $stmt_get_id->close();

    if ($deposit_to_cancel && !empty($deposit_to_cancel['gateway_id'])) {
        $gateway_id_to_cancel = $deposit_to_cancel['gateway_id'];

        // Ambil konfigurasi gateway
        $stmt_gw = $conn->prepare("SELECT url, apikey FROM payment_setting WHERE nama = 'atlantich2h'");
        $stmt_gw->execute();
        $gateway = $stmt_gw->get_result()->fetch_assoc();
        $stmt_gw->close();

        if ($gateway) {
            // Kirim permintaan cancel ke API gateway
            $api_url_cancel = rtrim($gateway['url'], '/') . '/deposit/cancel';
            $post_data_cancel = http_build_query(['api_key' => $gateway['apikey'], 'id' => $gateway_id_to_cancel]);
            
            $ch = curl_init();
            curl_setopt_array($ch, [CURLOPT_URL => $api_url_cancel, CURLOPT_POST => true, CURLOPT_POSTFIELDS => $post_data_cancel, CURLOPT_RETURNTRANSFER => true]);
            $response_cancel = curl_exec($ch);
            curl_close($ch);
            $response_cancel_data = json_decode($response_cancel, true);

            // Asumsi respon sukses adalah status:true
            if (isset($response_cancel_data['status']) && $response_cancel_data['status'] == true) {
                // Update status di database lokal menjadi 'Cancelled'
                $stmt_cancel_db = $conn->prepare("UPDATE deposits SET status = 'Cancelled' WHERE id_depo = ?");
                $stmt_cancel_db->bind_param("s", $reff_id);
                $stmt_cancel_db->execute();
                $stmt_cancel_db->close();
                
                $_SESSION['success_message'] = "Deposit dengan ID " . htmlspecialchars($reff_id) . " berhasil dibatalkan.";
                header("Location: deposit");
                exit();
            }
        }
    }
    // Jika gagal, kembali ke halaman pembayaran dengan pesan error
    $_SESSION['error_message'] = "Gagal membatalkan deposit.";
    header("Location: payment?reff_id=" . $reff_id);
    exit();
}

// 2. AMBIL DATA DEPOSIT UNTUK DITAMPILKAN
// ===================================
$stmt = $conn->prepare("SELECT * FROM deposits WHERE id_depo = ? AND username = ?");
$stmt->bind_param("ss", $reff_id, $username);
$stmt->execute();
$result = $stmt->get_result();
$deposit = $result->fetch_assoc();
$stmt->close();
$total_bayar = $deposit['nominal'] + $deposit['fee'];
if (!$deposit) {
    die("Data deposit tidak ditemukan atau bukan milik Anda.");
}
if ($deposit['status'] != 'Pending') {
    header("Location: deposit");
    exit();
}

$page_title = "Pembayaran Deposit";
require_once 'header.php';
?>

<div class="container">
    <main>
        <div class="payment-card">
            
            <div id="payment-view">
                <h2>Selesaikan Pembayaran</h2>
                <p>Pindai QR Code di bawah ini menggunakan aplikasi E-Wallet Anda.</p>
                <div class="payment-details">
                    <span>Total Pembayaran</span>
                    <strong>Rp <?php echo number_format($total_bayar, 0, ',', '.'); ?></strong>
                </div>
                <div class="qr-code">
                    <img src="<?php echo htmlspecialchars($deposit['payment_url']); ?>" alt="QR Code Pembayaran">
                </div>
                <div class="countdown">
                    <p>Bayar sebelum: <strong id="timer">Memuat...</strong></p>
                </div>
                <p id="status-check-info" style="color: #8A94A6; font-size: 0.9rem;">Mengecek status pembayaran secara otomatis...</p>

                <form action="payment?reff_id=<?php echo htmlspecialchars($reff_id); ?>" method="post" style="margin-top: 1.5rem;">
                    <input type="hidden" name="action" value="cancel">
                    <button type="submit" class="btn btn-secondary btn-block" onclick="return confirm('Anda yakin ingin membatalkan deposit ini?')">
                        Batalkan Deposit
                    </button>
                </form>
                 </div>
            <div id="success-view" style="display: none; text-align: center;">
                <svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="#28a745" class="bi bi-check-circle-fill" viewBox="0 0 16 16">
                  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z"/>
                </svg>
                <h2 style="margin-top: 1.5rem;">Pembayaran Berhasil!</h2>
                <p style="font-size: 1.1rem;">Saldo Anda telah berhasil ditambahkan.</p>
                <p style="color: #8A94A6;">Anda akan diarahkan ke halaman dashboard dalam <span id="redirect-timer">5</span> detik.</p>
            </div>

        </div>
    </main>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Bagian Timer Hitung Mundur
    const timerElement = document.getElementById('timer');
    const expiryTime = new Date("<?php echo str_replace(' ', 'T', $deposit['expired_at']); ?>").getTime();
    const countdownInterval = setInterval(function() {
        const now = new Date().getTime();
        const distance = expiryTime - now;
        if (distance < 0) {
            clearInterval(countdownInterval);
            timerElement.innerHTML = "WAKTU HABIS";
            timerElement.style.color = '#dc3545';
            // Hentikan pengecekan jika waktu habis
            if (statusCheckInterval) clearInterval(statusCheckInterval); 
            document.getElementById('status-check-info').textContent = "Waktu pembayaran telah habis.";
            return;
        }
        const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((distance % (1000 * 60)) / 1000);
        timerElement.innerHTML = minutes.toString().padStart(2, '0') + ":" + seconds.toString().padStart(2, '0');
    }, 1000);

    // Bagian Pengecekan Status Otomatis (Polling)
    const reffId = "<?php echo $reff_id; ?>";
    const statusCheckInterval = setInterval(function() {
        fetch(`check_status?reff_id=${reffId}`)
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    // Jika sukses, hentikan pengecekan & timer
                    clearInterval(statusCheckInterval);
                    clearInterval(countdownInterval);
                    
                    // Ganti tampilan ke 'Success View'
                    document.getElementById('payment-view').style.display = 'none';
                    document.getElementById('success-view').style.display = 'block';

                    // Mulai timer redirect ke dashboard
                    let count = 5;
                    const redirectTimerElement = document.getElementById('redirect-timer');
                    const redirectInterval = setInterval(() => {
                        count--;
                        redirectTimerElement.textContent = count;
                        if (count <= 0) {
                            clearInterval(redirectInterval);
                            window.location.href = '/'; // Ganti dengan URL dashboard Anda
                        }
                    }, 1000);
                }
                // Jika status 'pending', tidak melakukan apa-apa, tunggu pengecekan berikutnya.
                // Jika status 'final' (expired, failed, dll), hentikan pengecekan.
                if (data.status === 'final') {
                    clearInterval(statusCheckInterval);
                }
            })
            .catch(error => {
                console.error('Error checking status:', error);
            });
    }, 5000); // Cek status setiap 5 detik
});
</script>

<?php
require_once 'footer.php';
$conn->close();
?>
