<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once '../config.php';

if (!isset($_SESSION['username'])) {
    header("Location: /login");
    exit();
}
$username = $_SESSION['username'];
$message = null;
$message_type = 'error';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['kode_voucher'])) {
    $kode_voucher = trim($_POST['kode_voucher']);
    
    // Cek #1 - #4 (Tidak ada perubahan)
    $stmt = $conn->prepare("SELECT * FROM vouchers WHERE kode_voucher = ? AND status = 'aktif'");
    $stmt->bind_param("s", $kode_voucher);
    $stmt->execute();
    $voucher = $stmt->get_result()->fetch_assoc();

    if ($voucher) {
        // Cek #2: Apakah Sudah Kedaluwarsa?
        if ($voucher['tanggal_kadaluwarsa'] && $voucher['tanggal_kadaluwarsa'] < date('Y-m-d')) {
            $message = "Voucher sudah kedaluwarsa.";
        } else {
            // Cek #3: Apakah Kuota Masih Ada?
            $stmt_count = $conn->prepare("SELECT COUNT(id) as total FROM voucher_redemptions WHERE voucher_id = ?");
            $stmt_count->bind_param("i", $voucher['id']);
            $stmt_count->execute();
            $usage_count = $stmt_count->get_result()->fetch_assoc()['total'];

            if ($voucher['kuota'] > 0 && $usage_count >= $voucher['kuota']) {
                $message = "Kuota untuk voucher ini sudah habis.";
            } else {
                // Cek #4: Apakah Pengguna Ini Sudah Pernah Pakai?
                $stmt_user_check = $conn->prepare("SELECT id FROM voucher_redemptions WHERE voucher_id = ? AND username = ?");
                $stmt_user_check->bind_param("is", $voucher['id'], $username);
                $stmt_user_check->execute();
                if ($stmt_user_check->get_result()->num_rows > 0) {
                    $message = "Anda sudah pernah menggunakan voucher ini.";
                } else {
                    // JIKA SEMUA LOLOS: PROSES REDEEM
                    $conn->begin_transaction();
                    try {
                        $saldo_didapat = 0;
                        // --- LOGIKA BARU UNTUK JENIS VOUCHER ---
                        if ($voucher['jenis'] == 'saldo') {
                            $saldo_didapat = $voucher['jumlah_min'];
                        } elseif ($voucher['jenis'] == 'saldo_random') {
                            $saldo_didapat = rand((int)$voucher['jumlah_min'], (int)$voucher['jumlah_max']);
                        }
                        
                        if ($saldo_didapat > 0) {
                            // Tambahkan saldo yang didapat ke akun pengguna
                            $stmt_update_user = $conn->prepare("UPDATE users SET saldo = saldo + ? WHERE username = ?");
                            $stmt_update_user->bind_param("is", $saldo_didapat, $username);
                            $stmt_update_user->execute();
                        }
                        
                        // Catat penggunaan voucher
                        $stmt_insert_redemption = $conn->prepare("INSERT INTO voucher_redemptions (voucher_id, username) VALUES (?, ?)");
                        $stmt_insert_redemption->bind_param("is", $voucher['id'], $username);
                        $stmt_insert_redemption->execute();
            
                        $conn->commit();
                        $message_type = 'success';
                        
                        // --- PESAN SUKSES DINAMIS ---
                        if ($voucher['jenis'] == 'saldo') {
                            $message = "Voucher berhasil digunakan! Saldo sebesar Rp " . number_format($saldo_didapat) . " telah ditambahkan.";
                        } elseif ($voucher['jenis'] == 'saldo_random') {
                            $message = "Selamat! Anda mendapatkan saldo acak sebesar Rp " . number_format($saldo_didapat) . "! Saldo telah ditambahkan ke akun Anda.";
                        }
            
                    } catch (mysqli_sql_exception $exception) {
                        $conn->rollback();
                        $message = "Terjadi kesalahan pada server. Coba lagi.";
                    }
                }
            }
        }
    } else {
        $message = "Kode voucher tidak valid atau tidak aktif.";
    }
}

$page_title = "Redeem Voucher";
require_once 'header.php';
?>

<div class="container">
    <main>

        <div class="card-voucher">
            <?php if ($message): ?>
                <div class="alert alert-<?php echo ($message_type == 'success') ? 'success' : 'danger'; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <form action="redeem_voucher" method="post">
                <div class="form-group">
                    <label for="kode_voucher">Kode Voucher</label>
                    <input type="text" id="kode_voucher" name="kode_voucher" class="form-control" placeholder="Contoh: DISKONJULI" required>
                </div>
                <button type="submit" class="btn btn-primary btn-block">Gunakan Voucher</button>
            </form>
        </div>
    </main>
</div>

<?php
require_once 'footer.php';
$conn->close();
?>
