<?php
// 1. PENGATURAN & AUTENTIKASI
// ===================================
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once '../config.php';

// Cek jika pengguna sudah login
if (!isset($_SESSION['username'])) {
    header("Location: /login");
    exit();
}
$username = $_SESSION['username'];
$message = null;
$message_type = 'error';

// Ambil data user, termasuk apikey
$stmt_user = $conn->prepare("SELECT id, apikey FROM users WHERE username = ?");
$stmt_user->bind_param("s", $username);
$stmt_user->execute();
$user = $stmt_user->get_result()->fetch_assoc();

if (!$user) {
    die("User tidak ditemukan.");
}
$user_apikey = $user['apikey'];


// 2. PROSES UPLOAD SAAT FORM DISUBMIT
// ===================================
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $uploaded_file = isset($_FILES['gambar_slide']) ? $_FILES['gambar_slide'] : null;
    $url_tujuan = isset($_POST['url_tujuan']) ? trim($_POST['url_tujuan']) : null;

    // Validasi file
    if (!$uploaded_file || $uploaded_file['error'] !== UPLOAD_ERR_OK) {
        $message = "Anda harus memilih file gambar untuk diunggah.";
    } elseif ($uploaded_file['size'] > 2000000) { // Batas 2MB
        $message = "Ukuran gambar terlalu besar. Maksimal 2 MB.";
    } else {
        $file_info = pathinfo($uploaded_file['name']);
        $extension = strtolower($file_info['extension']);
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'webp'];

        if (!in_array($extension, $allowed_extensions)) {
            $message = "Format file tidak diizinkan. Hanya JPG, JPEG, PNG, & WEBP.";
        } else {
            $upload_dir = 'uploads/slides/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }

            $new_filename = bin2hex(random_bytes(16)) . '.' . $extension;
            $destination = $upload_dir . $new_filename;

            if (move_uploaded_file($uploaded_file['tmp_name'], $destination)) {
                $public_url = "https://" . $_SERVER['HTTP_HOST'] . "/" . $destination;

                // --- PERUBAHAN DI SINI ---
                // Query INSERT diubah untuk menyertakan kolom apikey
                $stmt_insert = $conn->prepare("INSERT INTO slides (url_gambar_slide, url_tujuan, apikey, status, urutan) VALUES (?, ?, ?, 'aktif', 0)");
                
                $url_tujuan_db = !empty($url_tujuan) ? $url_tujuan : null;
                
                // bind_param diubah untuk menyertakan $user_apikey
                $stmt_insert->bind_param("sss", $public_url, $url_tujuan_db, $user_apikey);

                if ($stmt_insert->execute()) {
                    $message_type = 'success';
                    $message = "Slide baru berhasil ditambahkan!";
                } else {
                    $message = "Gagal menyimpan data ke database.";
                }
                $stmt_insert->close();
            } else {
                $message = "Gagal memindahkan file yang diunggah.";
            }
        }
    }
}

// 3. AMBIL DATA SLIDE YANG SUDAH ADA DARI DATABASE
// ==================================================
$slides = [];
$sql = "SELECT id, url_gambar_slide, url_tujuan, status FROM slides ORDER BY urutan ASC";
$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $slides[] = $row;
    }
}


$page_title = "Slide";
require_once 'header.php';
?>
<style>
    .form-group label {
        font-size: 0.9rem;
        margin-bottom: 0.2rem;
    }
    .form-control {
        padding: 0.5rem 0.75rem;
        font-size: 0.9rem;
    }
    .btn-primary {
        padding: 0.6rem 1rem;
        font-size: 0.9rem;
    }
    .card {
        padding: 1.5rem;
    }
    .page-header h1 {
        font-size: 1.5rem;
        margin-bottom: 0.5rem;
    }
    .page-header p {
        font-size: 0.85rem;
    }
    .form-group small {
        font-size: 0.8rem;
        display: block;
        margin-top: 0.2rem;
        color: #6c757d;
    }
</style>
<div class="container">
    <main>
        <div class="page-header">
            <h1>Slide</h1>
        </div>

        <div class="card">
            <?php if ($message): ?>
                <div class="alert alert-<?php echo ($message_type == 'success') ? 'success' : 'danger'; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <form action="slide" method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="gambar_slide">Pilih Gambar Slide</label>
                    <input type="file" id="gambar_slide" name="gambar_slide" class="form-control" required>
                    <small>Ukuran rekomendasi 1280x720 pixel, Maks. 2MB.</small>
                </div>
                <div class="form-group">
                    <label for="url_tujuan">URL Tujuan (Opsional)</label>
                    <input type="url" id="url_tujuan" name="url_tujuan" class="form-control" placeholder="https://website-tujuan.com">
                    <small>Jika diisi, slide akan bisa diklik dan mengarah ke URL ini.</small>
                </div>
                <button type="submit" class="btn btn-primary btn-block">Simpan Slide</button>
            </form>
        </div>

        <div class="history-section">
            <h2>Daftar Slide Terpasang</h2>
            <div class="card">
                <div class="table-responsive">
                    <table class="history-table">
                        <thead>
                            <tr>
                                <th>Gambar</th>
                                <th>URL Tujuan</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($slides)): ?>
                                <tr>
                                    <td colspan="4" style="text-align: center; padding: 2rem;">Belum ada slide yang diunggah.</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($slides as $slide): ?>
                                    <tr>
                                        <td data-label="Gambar">
                                            <?php echo htmlspecialchars($slide['url_gambar_slide']); ?>
                                        </td>
                                        <td data-label="URL Tujuan">
                                            <?php if (!empty($slide['url_tujuan'])): ?>
                                                <a href="<?php echo htmlspecialchars($slide['url_tujuan']); ?>" target="_blank">Lihat Link</a>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td data-label="Status">
                                            <span class="status-badge status-<?php echo ($slide['status'] == 'aktif') ? 'success' : 'failed'; ?>">
                                                <?php echo htmlspecialchars($slide['status']); ?>
                                            </span>
                                        </td>
                                        <td data-label="Aksi">
                                            <a href="#" class="btn btn-sm btn-danger">Hapus</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>
</div>

<?php
require_once 'footer.php';
$conn->close();
?>
