<?php
// Mengatur header agar outputnya selalu JSON dan bisa diakses dari mana saja
header("Access-Control-Allow-Origin: *"); 
header('Content-Type: application/json');

// Memanggil file koneksi database
require_once '../../config.php';

/**
 * Fungsi untuk mengirim respons JSON dan menghentikan skrip.
 */
function send_response($status_code, $data) {
    http_response_code($status_code);
    echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}


// ==========================================================
// --- BLOK BARU: VALIDASI & AUTENTIKASI API KEY ---
// ==========================================================

// 1. Ambil apikey dari parameter URL
$user_apikey = isset($_GET['apikey']) ? trim($_GET['apikey']) : null;

// 2. Cek apakah parameter apikey ada
if (empty($user_apikey)) {
    send_response(400, [
        'code' => 400,
        'status' => 'error',
        'message' => 'Bad Request. Parameter "apikey" is required.'
    ]);
}

// 3. Cek apikey di database users
$stmt = $conn->prepare("SELECT id FROM users WHERE apikey = ? LIMIT 1");
$stmt->bind_param("s", $user_apikey);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows === 0) {
    $stmt->close();
    send_response(401, [
        'code' => 401,
        'status' => 'error',
        'message' => 'Unauthorized. Invalid API Key.'
    ]);
}
$stmt->close();
// ==========================================================


// Menyiapkan array untuk respons akhir
$response = [
    'code' => 500, // Default error code
    'status' => 'error',
    'data' => []
];

try {
    // Ambil semua slide yang berstatus 'aktif' dari database
    $sql = "SELECT url_gambar_slide, url_tujuan FROM slides WHERE status = 'aktif' ORDER BY urutan ASC";
    $result = $conn->query($sql);

    $slides_data = [];
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $slides_data[] = $row;
        }
    }

    // Susun data respons sesuai format yang diinginkan
    $response['code'] = 200;
    $response['status'] = 'ok';
    $response['data'] = $slides_data;

} catch (Exception $e) {
    $response['message'] = 'Internal Server Error: ' . $e->getMessage();
}

// Tutup koneksi dan kirim respons JSON
$conn->close();
echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
exit;
?>
