// Tempelkan kode JavaScript di sini
document.addEventListener("DOMContentLoaded", function() {
    const copyButton = document.getElementById('copyButton');
    const apiKeyElement = document.getElementById('apiKey');

    if (copyButton && apiKeyElement) {
        const originalButtonHTML = copyButton.innerHTML;
        copyButton.addEventListener('click', function() {
            const apiKeyToCopy = apiKeyElement.textContent.trim();
            navigator.clipboard.writeText(apiKeyToCopy).then(() => {
                copyButton.innerHTML = '✅ Tersalin!';
                copyButton.classList.add('copied');
                setTimeout(() => {
                    copyButton.innerHTML = originalButtonHTML;
                    copyButton.classList.remove('copied');
                }, 2000);
            }).catch(err => {
                console.error('Gagal menyalin API key:', err);
                alert('Gagal menyalin API key.');
            });
        });
    }
});
window.onload = function() {
  // Build a system
  const ui = SwaggerUIBundle({
    url: 'openapi.yaml',
    dom_id: '#swagger-ui',
    presets: [
      SwaggerUIBundle.presets.apis,
      SwaggerUIBundle.SwaggerUIStandalonePreset
    ],
    layout: "BaseLayout"
  });
  window.ui = ui;
};