<?php
require_once "../setting/database.php";

$username = $new_password = "";
$username_err = $new_password_err = "";
$reset_success = "";

if($_SERVER["REQUEST_METHOD"] == "POST"){
    // Validasi username
    if(empty(trim($_POST["username"]))){
        $username_err = "Silakan masukkan username Anda.";
    } else {
        $username = trim($_POST["username"]);
    }

    // Validasi password baru
    if(empty(trim($_POST["new_password"]))){
        $new_password_err = "Silakan masukkan password baru.";
    } elseif(strlen(trim($_POST["new_password"])) < 6){
        $new_password_err = "Password minimal harus 6 karakter.";
    } else{
        $new_password = trim($_POST["new_password"]);
    }

    // Cek error sebelum update database
    if(empty($username_err) && empty($new_password_err)){
        $sql = "UPDATE users SET password = ? WHERE username = ?";
        if($stmt = mysqli_prepare($link, $sql)){
            mysqli_stmt_bind_param($stmt, "ss", $param_password, $param_username);
            
            $param_password = password_hash($new_password, PASSWORD_DEFAULT);
            $param_username = $username;

            if(mysqli_stmt_execute($stmt)){
                 if(mysqli_stmt_affected_rows($stmt) == 1){
                    $reset_success = "Password berhasil diperbarui. Silakan login kembali.";
                 } else {
                    $username_err = "Tidak ada akun yang ditemukan dengan username tersebut.";
                 }
            } else{
                echo "Oops! Terjadi kesalahan. Silakan coba lagi nanti.";
            }
            mysqli_stmt_close($stmt);
        }
    }
    mysqli_close($link);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atur Ulang Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
        body, html { height: 100%; }
        .container-reset { display: flex; align-items: center; justify-content: center; min-height: 100%; }
        .card { width: 100%; max-width: 400px; }
    </style>
</head>
<body class="bg-light">

    <div class="container-reset">
        <div class="card shadow-sm">
            <div class="card-body p-4 p-md-5">
                <h2 class="card-title text-center mb-4">Atur Ulang Password</h2>
                
                <?php if(!empty($reset_success)){ echo '<div class="alert alert-success">' . $reset_success . '</div>'; } ?>

                <form action="lupa-password" method="post" novalidate>
                    <div class="mb-3">
                        <label for="username" class="form-label">Username</label>
                        <input type="text" name="username" id="username" class="form-control <?php echo (!empty($username_err)) ? 'is-invalid' : ''; ?>" value="<?php echo htmlspecialchars($username); ?>">
                        <div class="invalid-feedback">
                            <?php echo $username_err; ?>
                        </div>
                    </div>    
                    <div class="mb-3">
                        <label for="new_password" class="form-label">Password Baru</label>
                        <input type="password" name="new_password" id="new_password" class="form-control <?php echo (!empty($new_password_err)) ? 'is-invalid' : ''; ?>">
                        <div class="invalid-feedback">
                            <?php echo $new_password_err; ?>
                        </div>
                    </div>
                    <div class="d-grid mt-4">
                        <button type="submit" class="btn btn-primary">Atur Ulang Password</button>
                    </div>
                    <hr class="my-4">
                    <p class="text-center"><a href="login">Kembali ke halaman Login</a></p>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>
