<?php
session_start();

if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login");
    exit;
}

require_once "setting/database.php";

$user_details = [];
// Ambil semua detail pengguna dari database
$sql = "SELECT * FROM users WHERE id = ?";
if($stmt = mysqli_prepare($link, $sql)){
    mysqli_stmt_bind_param($stmt, "i", $_SESSION["id"]);
    if(mysqli_stmt_execute($stmt)){
        $result = mysqli_stmt_get_result($stmt);
        $user_details = mysqli_fetch_assoc($result);
    } else {
        // Handle error jika query gagal
        die("Gagal mengambil data pengguna.");
    }
    mysqli_stmt_close($stmt);
}
mysqli_close($link);

// --- LOGIKA BARU UNTUK MENGHITUNG SISA HARI ---

// Ubah tanggal dari database dan tanggal sekarang menjadi format timestamp (detik)
$masa_aktif_timestamp = strtotime($user_details['masa_aktif']);
$sekarang_timestamp = time();

$sisa_hari = 0; // Nilai default jika sudah expired

// Cek apakah masa aktif masih di masa depan
if ($masa_aktif_timestamp > $sekarang_timestamp) {
    // Hitung selisih waktu dalam detik
    $selisih_detik = $masa_aktif_timestamp - $sekarang_timestamp;
    // Konversi detik menjadi hari, lalu bulatkan ke atas dengan ceil()
    $sisa_hari = ceil($selisih_detik / (60 * 60 * 24));
}

// Tentukan status expired berdasarkan sisa hari
$is_expired = $sisa_hari <= 0;

// --- AKHIR DARI LOGIKA BARU ---

require_once 'menu/header.php';
?>
<div class="container mt-5">
  <div class="info-grid">
    
    <div class="card">
        <p class="label">Masa Aktif</p>
        <p class="value"><?php echo $sisa_hari; ?> Hari <?php echo $is_expired ? '<span class="badge bg-danger">Expired</span>' : ''; ?></p>
    </div>
    
    <div class="card">
        <p class="label">Hit Hari Ini</p>
        <p class="value"><?php echo htmlspecialchars($user_details['hit_hari_ini']); ?></p>
    </div>
    <div class="card">
        <p class="label">Total Hit</p>
        <p class="value"><?php echo htmlspecialchars($user_details['total_hit']); ?></p>
    </div>
    <div class="card">
        <p class="label">Limit</p>
        <p class="value saldo"><?php echo htmlspecialchars($user_details['limit_user']); ?></p>
    </div>
    <div class="card">
        <p class="label">Saldo</p>
        <p class="value saldo">Rp <?php echo number_format($user_details['saldo'], 2, ',', '.'); ?></p>
    </div>
  </div>
  <div class="apikey-section text-bg-primary">
    <p class="label text-center text-white">Apikeymu</p>
      <div class="apikey-display text-bg-white" id="apiKey"><?php echo htmlspecialchars($user_details['apikey']); ?></div>
      <div class="d-flex">
      <button class="btn copy-button" id="copyButton">
          <svg xmlns="http://www.w3.org/2000/svg" width="13" height="13" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z"/><path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"/><path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"/></svg>
          Salin Apikey
      </button>
      </div>
  </div>
</div>
<?php
require_once 'menu/footer.php';
// $conn->close(); // Baris ini mungkin tidak diperlukan jika Anda menggunakan mysqli_close($link)
?>
