<?php

// --- 1. PENGAMBILAN DATA DARI API (Tidak ada perubahan di bagian ini) ---
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://atlantich2h.com/layanan/price_list',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 'api_key=2IlkUzIHCJNNVu4g5oRoCcNxeUTaxP3tJngs7uOf8x6pOqAGwoI72aQ3Vn3nhEuXfonu0kzmIm14RRge5xqPuDCQIq8icJvEaYFU&type=prabayar',
));

$response = curl_exec($curl);
$error = curl_error($curl);
curl_close($curl);

// --- 2. PROSES DATA JSON (Tidak ada perubahan di bagian ini) ---
$data = json_decode($response, true);
$groupedProducts = [];

if ($data && $data['status'] === true && !empty($data['data'])) {
    foreach ($data['data'] as $product) {
        $category = $product['category'];
        if (!isset($groupedProducts[$category])) {
            $groupedProducts[$category] = [];
        }
        $groupedProducts[$category][] = $product;
    }
} else {
    die("Gagal mengambil data dari API. Pesan error: " . htmlspecialchars($error));
}

?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Harga Produk (Dropdown)</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; margin: 20px; background-color: #f4f4f9; color: #333; }
        .container { max-width: 800px; margin: auto; background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
        h1 { text-align: center; color: #2c3e50; }
        .form-group { margin-bottom: 25px; }
        label { display: block; margin-bottom: 8px; font-weight: bold; color: #3498db; }
        select { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 16px; background-color: #fff; }
        /* Sembunyikan semua tabel produk secara default */
        .product-table { display: none; margin-top: 20px; }
        table { width: 100%; border-collapse: collapse; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        th, td { padding: 12px 15px; border: 1px solid #ddd; text-align: left; }
        thead { background-color: #34495e; color: #ffffff; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        .status-available { color: #27ae60; font-weight: bold; }
        .status-empty { color: #c0392b; font-weight: bold; }
        .price { font-weight: bold; }
    </style>
</head>
<body>

<div class="container">
    <h1>Daftar Harga Produk</h1>

    <div class="form-group">
        <label for="category-select">Pilih Kategori:</label>
        <select id="category-select">
            <option value="">-- Silakan Pilih --</option>
            <?php foreach ($groupedProducts as $categoryName => $products) : ?>
                <?php
                    // Membuat ID yang unik dan aman untuk JavaScript dari nama kategori
                    // Contoh: "Data Internet" menjadi "data-internet"
                    $categoryId = strtolower(str_replace(' ', '-', $categoryName));
                ?>
                <option value="<?php echo htmlspecialchars($categoryId); ?>"><?php echo htmlspecialchars($categoryName); ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <?php foreach ($groupedProducts as $categoryName => $products) : ?>
        <?php $categoryId = strtolower(str_replace(' ', '-', $categoryName)); ?>
        <div id="<?php echo htmlspecialchars($categoryId); ?>" class="product-table">
            <table>
                <thead>
                    <tr>
                        <th>Nama Produk</th>
                        <th>Harga</th>
                        <th>Status</th>
                        <th>Kode</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $item) : ?>
                        <tr>
                            <td><?php echo htmlspecialchars($item['name']); ?></td>
                            <td class="price"><?php echo 'Rp ' . number_format($item['price'], 0, ',', '.'); ?></td>
                            <td>
                                <?php if ($item['status'] == 'available') : ?>
                                    <span class="status-available">Tersedia</span>
                                <?php else : ?>
                                    <span class="status-empty">Kosong</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo htmlspecialchars($item['code']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endforeach; ?>
</div>

<script>
    document.getElementById('category-select').addEventListener('change', function() {
        // Dapatkan ID kategori yang dipilih dari value dropdown
        var selectedCategory = this.value;

        // Ambil semua elemen tabel produk
        var allTables = document.querySelectorAll('.product-table');

        // Sembunyikan semua tabel terlebih dahulu
        allTables.forEach(function(table) {
            table.style.display = 'none';
        });

        // Jika ada kategori yang dipilih (bukan pilihan '-- Silakan Pilih --')
        if (selectedCategory) {
            // Tampilkan tabel yang ID-nya cocok dengan kategori yang dipilih
            var tableToShow = document.getElementById(selectedCategory);
            if (tableToShow) {
                tableToShow.style.display = 'block';
            }
        }
    });
</script>

</body>
</html>
