<?php
// override.php
header('Content-Type: application/json');

// Secret callback Anda (harus sama dengan yang ada di tab Callback)
$my_secret_callback = '27284b9e7047f18d8844572991d6eb4b';

// Ambil data POST dari server bukaOlshop
$data = $_POST;

// Cek apakah semua field ada
$required_fields = ['status','id_user','token_topup','jumlah_topup','kode_unik','total_topup','secret_callback'];
foreach ($required_fields as $field) {
    if (!isset($data[$field])) {
        echo json_encode([
            'status' => 'error',
            'message' => "Field $field tidak ada"
        ]);
        exit;
    }
}

// Cek secret_callback
if ($data['secret_callback'] !== $my_secret_callback) {
    echo json_encode([
        'status' => 'error',
        'message' => "Secret callback tidak cocok"
    ]);
    exit;
}

// Jika status ok, lakukan proses topup
if ($data['status'] === 'ok') {
    $id_user = $data['id_user'];
    $token_topup = $data['token_topup'];
    $jumlah_topup = $data['jumlah_topup'];
    $kode_unik = $data['kode_unik'];
    $total_topup = $data['total_topup'];

    // Contoh: update saldo user di database
    // require 'config.php';
    // $update = $conn->prepare("UPDATE users SET saldo = saldo + ? WHERE id = ?");
    // $update->execute([$total_topup, $id_user]);

    // Balas ke server
    echo json_encode([
        'status' => 'success',
        'message' => 'Topup berhasil diterima',
        'id_user' => $id_user,
        'token_topup' => $token_topup
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Status bukan ok'
    ]);
}
?>