<?php
// =================================================================
// KONFIGURASI DATABASE ANDA
// =================================================================
$db_host = 'localhost'; // Biasanya 'localhost'
$db_user = 'resende1_api2';      // User database Anda
$db_pass = 'resende1_api2';          // Password database Anda
$db_name = 'resende1_api2'; // Nama database Anda

// =================================================================
// 1. PANGGIL API
// =================================================================
$curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://atlantich2h.com/deposit/metode',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 'api_key=2IlkUzIHCJNNVu4g5oRoCcNxeUTaxP3tJngs7uOf8x6pOqAGwoI72aQ3Vn3nhEuXfonu0kzmIm14RRge5xqPuDCQIq8icJvEaYFU',
));
$response = curl_exec($curl);
curl_close($curl);

// =================================================================
// 2. PROSES DAN SIMPAN DATA KE DATABASE
// =================================================================

// Decode JSON menjadi array PHP
$data = json_decode($response, true);

// Cek jika data valid
if ($data && isset($data['status']) && $data['status'] === true && !empty($data['data'])) {
    
    // Buat koneksi ke database
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

    // Cek koneksi
    if ($conn->connect_error) {
        die("Koneksi ke database gagal: " . $conn->connect_error);
    }

    echo "Koneksi database berhasil. Memulai proses input/update...<br>";

    // **[MODIFIKASI]** Siapkan query SQL untuk memasukkan semua kolom
    // ON DUPLICATE KEY UPDATE akan memperbarui data jika 'metode' sudah ada
    $sql = "INSERT INTO metode_pembayaran (metode, nama, image, status, `type`, min_deposit, max_deposit, fee, fee_persen) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) 
            ON DUPLICATE KEY UPDATE 
                nama = VALUES(nama), 
                image = VALUES(image), 
                status = VALUES(status),
                `type` = VALUES(`type`),
                min_deposit = VALUES(min_deposit),
                max_deposit = VALUES(max_deposit),
                fee = VALUES(fee),
                fee_persen = VALUES(fee_persen)";
    
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        die("Gagal mempersiapkan statement SQL: " . $conn->error);
    }

    // Loop melalui setiap metode dari API
    foreach ($data['data'] as $metode_item) {
        // **[MODIFIKASI]** Ambil semua data yang dibutuhkan dari JSON
        $kode_metode = $metode_item['metode'];
        $nama_metode = $metode_item['name'];
        $img_url     = $metode_item['img_url'];
        $status      = $metode_item['status'];
        $type        = $metode_item['type'];
        $min_deposit = $metode_item['min'];
        $max_deposit = $metode_item['max'];
        $fee         = $metode_item['fee'];
        $fee_persen  = $metode_item['fee_persen'];

        // **[MODIFIKASI]** Bind 9 parameter ke statement SQL
        // "sssssdddd" berarti: 5 string, 4 double (angka)
        $stmt->bind_param("sssssdddd", 
            $kode_metode, 
            $nama_metode, 
            $img_url, 
            $status, 
            $type, 
            $min_deposit, 
            $max_deposit, 
            $fee, 
            $fee_persen
        );

        // Eksekusi query
        if ($stmt->execute()) {
            echo "Berhasil menyisipkan/memperbarui data untuk: <strong>{$nama_metode}</strong><br>";
        } else {
            echo "Gagal untuk {$nama_metode}: " . $stmt->error . "<br>";
        }
    }

    echo "Proses selesai.<br>";

    // Tutup statement dan koneksi
    $stmt->close();
    $conn->close();

} else {
    echo "Gagal mengambil data dari API atau tidak ada data yang tersedia.";
    // Tampilkan response mentah untuk debugging jika perlu
    // echo "<pre>";
    // print_r($response);
    // echo "</pre>";
}

?>
