<?php
function detect_ai_code($code) {
    $score = 0;
    $reasons = [];

    // 1. Cek jumlah komentar dan panjangnya
    preg_match_all('/(#.*|\/\/.*|\/\*[\s\S]*?\*\/)/', $code, $comments);
    $comment_count = count($comments[0]);
    $avg_comment_len = $comment_count > 0 ? array_sum(array_map('strlen', $comments[0])) / $comment_count : 0;

    if ($avg_comment_len > 50) {
        $score += 2;
        $reasons[] = "Komentar sangat panjang (AI biasanya memberi penjelasan detail).";
    } elseif ($avg_comment_len > 20) {
        $score += 1;
        $reasons[] = "Komentar cukup panjang.";
    }

    // 2. Cek nama variabel panjang
    preg_match_all('/\b[a-zA-Z_][a-zA-Z0-9_]*\b/', $code, $variables);
    $long_vars = array_filter($variables[0], fn($v) => strlen($v) > 12);
    if (count($long_vars) > 2) {
        $score += 2;
        $reasons[] = "Banyak variabel dengan nama panjang deskriptif.";
    }

    // 3. Cek konsistensi indentasi
    $lines = explode("\n", $code);
    $indent_lines = count(array_filter($lines, fn($l) => preg_match('/^(    |\t)/', $l)));
    if (count($lines) > 0 && ($indent_lines / count($lines)) > 0.6) {
        $score += 1;
        $reasons[] = "Indentasi sangat konsisten (ciri khas AI).";
    }

    // 4. Cek banyaknya import / require / use
    preg_match_all('/(require|include|use\s+[a-zA-Z_]|import\s+\w+)/', $code, $imports);
    if (count($imports[0]) > 5) {
        $score += 1;
        $reasons[] = "Banyak import/require (AI sering menambahkan modul tambahan).";
    }

    // 5. Cek pola 'penjelasan + kode'
    if (preg_match('/(#|\/\/).*?\n.*;/', $code)) {
        $score += 1;
        $reasons[] = "Ada pola komentar diikuti kode (gaya penjelasan AI).";
    }

    // Penilaian akhir
    if ($score >= 5) {
        $verdict = "Kemungkinan besar kode ini dibuat oleh AI.";
    } elseif ($score >= 3) {
        $verdict = "Kemungkinan campuran AI dan manusia.";
    } else {
        $verdict = "Kemungkinan besar kode ini dibuat oleh manusia.";
    }

    return [
        "score" => $score,
        "verdict" => $verdict,
        "reasons" => $reasons
    ];
}

// Contoh penggunaan
$kode = <<<EOD
<?php
// Fungsi untuk mengambil data dari API eksternal
// Menggunakan method GET untuk mendapatkan hasil dalam format JSON
function getData(\$url) {
    \$ch = curl_init(\$url);
    curl_setopt(\$ch, CURLOPT_RETURNTRANSFER, true);
    \$response = curl_exec(\$ch);
    curl_close(\$ch);
    return json_decode(\$response, true);
}
EOD;

$hasil = detect_ai_code($kode);
echo "Skor: {$hasil['score']}\n";
echo "Analisis: {$hasil['verdict']}\n";
foreach ($hasil['reasons'] as $r) {
    echo "- {$r}\n";
}
?>