
const searchInput = document.getElementById('searchGame');
    const noResult = document.getElementById('noResult');
    searchInput.addEventListener('keyup', function () {
        const filter = this.value.toLowerCase();
        const menuItems = document.querySelectorAll('.menu-panel-layanan .menu');
        let visibleCount = 0;
        menuItems.forEach(function (menu) {
            const gameName = menu.querySelector('p').textContent.toLowerCase();
            if (gameName.includes(filter)) {
                menu.style.display = '';
                visibleCount++;
            } else {
                menu.style.display = 'none';
            }
        });
        if (visibleCount === 0) {
            noResult.style.display = 'block';
        } else {
            noResult.style.display = 'none';
        }
    });


function getUcapan() {
    const now = new Date();
    const jam = now.getHours();
    let ucapan = "";
    if (jam >= 4 && jam < 11) {
        ucapan = "Selamat Pagi 🌞";
    } else if (jam >= 11 && jam < 15) {
        ucapan = "Selamat Siang ☀️";
    } else if (jam >= 15 && jam < 18) {
        ucapan = "Selamat Sore 🌤️";
    } else {
        ucapan = "Selamat Malam 🌙";
    }
    document.getElementById("ucapan").textContent = ucapan;
}
getUcapan();


function toggleOffcanvas(targetId, show) {
  const offcanvas = document.getElementById(targetId);
  const overlay = document.getElementById("overlay" + targetId.replace("offcanvas", ""));
  if (offcanvas && overlay) {
    if (show) {
      offcanvas.style.transform = "translateY(0)";
      overlay.style.display = "block";
    } else {
      offcanvas.style.transform = "translateY(100%)";
      overlay.style.display = "none";
    }
  }
}
document.querySelectorAll(".btn-toggle-offcanvas").forEach(btn => {
  btn.addEventListener("click", () => {
    const target = btn.getAttribute("data-target");
    toggleOffcanvas(target, true);
  });
});
document.querySelectorAll(".overlay").forEach(overlay => {
  overlay.addEventListener("click", () => {
    const id = overlay.id.replace("overlay", "offcanvas");
    toggleOffcanvas(id, false);
  });
});


function changeTab(index) {
        document.querySelector(".tab-indicator").style.transform = `translateX(${index * 100}%)`;
        document.querySelector(".content").style.transform = `translateX(-${index * 100}%)`;
        document.querySelectorAll(".tab-link").forEach((btn, i) => {
                btn.classList.toggle("active", i === index);
    });
}


    const collapses = document.querySelectorAll('.collapse-container');
    collapses.forEach(container => {
        const header = container.querySelector('.collapse-header');
        header.addEventListener('click', () => {
            collapses.forEach(c => c.classList.remove('active'));
            container.classList.add('active');
        });
    });


   function formatRupiah(angka) {
    let reverse = angka.toString().split('').reverse().join(''),
        ribuan = reverse.match(/\d{1,3}/g);
    ribuan = ribuan.join('.').split('').reverse().join('');
    return ribuan;
}

const saldoElement = document.getElementById('saldo-member');
const toggleIcon = document.getElementById('toggle-saldo');
const saldoAsli = saldoElement.getAttribute('data-saldo');
let isVisible = false;

toggleIcon.addEventListener('click', () => {
    isVisible = !isVisible;
    if (isVisible) {
        saldoElement.textContent = formatRupiah(saldoAsli);
        toggleIcon.classList.remove('fa-eye');
        toggleIcon.classList.add('fa-eye-slash');
    } else {
        saldoElement.textContent = '*****';
        toggleIcon.classList.remove('fa-eye-slash');
        toggleIcon.classList.add('fa-eye');
    }
});
  