<?php
require '../google/vendor/autoload.php';
require_once '../config/database.php';
require_once '../config/setting.php';

session_start();

$client = new Google_Client();
$client->setClientId(GOOGLE_CLIENT_ID);
$client->setClientSecret(GOOGLE_CLIENT_SECRET);
$client->setRedirectUri(GOOGLE_REDIRECT_URI);

if (isset($_GET['code'])) {
    $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);
    if (!isset($token['error'])) {
        $client->setAccessToken($token);
        $google_service = new Google_Service_Oauth2($client);
        $user_info = $google_service->userinfo->get();

        $google_id = $user_info->id;
        $email = $user_info->email;
        $name = $user_info->name;
        $picture = $user_info->picture;

        // Periksa apakah user sudah ada
        $stmt = $conn->prepare("SELECT * FROM users WHERE google_id = ? OR email = ?");
        $stmt->bind_param("ss", $google_id, $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            // Sudah terdaftar → login langsung
            $user = $result->fetch_assoc();
            $_SESSION['username'] = $user['username'];
        } else {
            // Belum terdaftar → buat akun otomatis
            $username = explode('@', $email)[0]; // Ambil bagian awal email
            $password_hash = password_hash(bin2hex(random_bytes(6)), PASSWORD_DEFAULT);
            $api_key = bin2hex(random_bytes(6));
            
            $stmt_insert = $conn->prepare("INSERT INTO users (username, email, google_id, password, picture, apikey) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt_insert->bind_param("ssssss", $username, $email, $google_id, $password_hash, $picture, $api_key);
            $stmt_insert->execute();

            $_SESSION['username'] = $username;
        }

        header("Location: /");
        exit();
    }
}
echo "Login via Google gagal.";