<?php
// Sertakan file konfigurasi
require_once '../config/database.php';
require_once '../config/setting.php';
require '../google/vendor/autoload.php';

$client = new Google_Client();
$client->setClientId(GOOGLE_CLIENT_ID);
$client->setClientSecret(GOOGLE_CLIENT_SECRET);
$client->setRedirectUri(GOOGLE_REDIRECT_URI);
$client->addScope("email");
$client->addScope("profile");

$google_login_url = $client->createAuthUrl();
// Mulai session jika belum ada
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$error_message = '';

// Jika sudah login (berdasarkan username), redirect ke index
// --- PERUBAHAN 1: Cek session 'username', bukan 'user_id' ---
if (isset($_SESSION['username'])) {
    header("Location: /");
    exit();
}

// Cek jika form telah disubmit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $conn->real_escape_string(trim($_POST['username']));
    $password = $conn->real_escape_string(trim($_POST['password']));

    if (empty($username) || empty($password)) {
        $error_message = "Username dan password tidak boleh kosong!";
    } else {
        // Cari pengguna berdasarkan username
        $stmt = $conn->prepare("SELECT id, username, password FROM users WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows == 1) {
            $user = $result->fetch_assoc();
            
            // Verifikasi password
            if (password_verify($password, $user['password'])) {
                // Password benar, buat session
                // --- PERUBAHAN 2: Hapus penyimpanan 'user_id' ke session ---
                // $_SESSION['user_id'] = $user['id']; // Baris ini dihapus/dikomentari
                $_SESSION['username'] = $user['username'];
                
                // Redirect ke halaman utama
                header("Location: /");
                exit();
            } else {
                $error_message = "Username password salah.";
            }
        } else {
            $error_message = "Username atau password salah.";
        }
        $stmt->close();
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
      <style>
      /* == 1. General Body & Centering == */
      body {
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      font-family: sans-serif;
      background-color: #00a4ff;
      }
      /* == 2. Form Container == */
      .container {
          width: 300px;
          padding: 2rem;
          background: #fff;
          border-radius: 8px;
          box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      }
      
      h2 {
          margin-bottom: 1.5rem;
          text-align: center;
          color: #000;
      }
      
      /* == 3. Form Elements == */
      .form-group {
          margin-bottom: 1rem;
          width: 100%;
          color: #000;
      }
      
      label {
          display: block;
          margin-bottom: 0.5rem;
      }
      
      input {
          padding: 0.5rem;
          width: 285px;
          border: 1px solid #ccc;
          border-radius: 4px;
      }
      
      button {
          width: 100%;
          padding: 0.7rem;
          color: #fff;
          background-color: #28a745;
          border: none;
          border-radius: 4px;
          cursor: pointer;
      }
      
      /* == 4. Helper &amp; Message Classes == */
      .message {
          margin-top: 1rem;
          padding: 0.7rem;
          color: #721c24;
          background-color: #f8d7da;
          border-radius: 4px;
          text-align: center;
      }
      
      .register-link {
          margin-top: 1rem;
          text-align: center;
          color: #000;
      }
      
      .register-link a{
        color: #a9a5a5; 
        text-decoration: none;
      }
      
  </style>
</head>
<body>
    <div class="container">
        <h2>Login</h2>
        <?php if ($error_message): ?>
            <div class="message"><?php echo $error_message; ?></div>
        <?php endif; ?>
        <form action="login" method="post">
            <div class="form-group">
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit">Login</button>
            <a href="<?= htmlspecialchars($google_login_url) ?>" style="display:block; text-align:center; margin-top:10px; background:#db4437; color:white; padding:10px; border-radius:4px; text-decoration:none;">
                Login dengan Google
            </a>
        </form>
         <div class="register-link">
            <p>Belum punya akun? <a href="/daftar">Daftar di sini</a></p>
            <p>Lupa password? <a href="/lupa-password">Reset Password</a></p>
        </div>
    </div>
</body>
</html>