<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once 'config/database.php';
require_once 'config/setting.php';
// Contoh variabel dinamis dari PHP

$total_notif     = 5;

if (!isset($_SESSION['username'])) {
    header("Location: /login");
    exit();
}
$username = $_SESSION['username'];

// 2. AMBIL DATA PENGGUNA
$stmt = $conn->prepare("SELECT * FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    session_destroy();
    header("Location: /login");
    exit();
}
// ## 1. PENGAMBILAN DATA DARI API MENGGUNAKAN cURL ##
$apiKey = '2IlkUzIHCJNNVu4g5oRoCcNxeUTaxP3tJngs7uOf8x6pOqAGwoI72aQ3Vn3nhEuXfonu0kzmIm14RRge5xqPuDCQIq8icJvEaYFU';
$postData = http_build_query([
    'api_key' => $apiKey,
    'type' => 'prabayar'
]);
$url = 'https://atlantich2h.com/layanan/price_list';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    die('cURL Error: ' . curl_error($ch));
}
curl_close($ch);

$data = json_decode($response, true);

$productsHTML = '';
$products2HTML = '';
$products3HTML = '';
$products5HTML = '';

// ## 2. PEMROSESAN DAN FILTER DATA ##
if (isset($data['status']) && $data['status'] === true && !empty($data['data'])) {
    
    // Definisikan daftar provider untuk setiap kategori (Duplikat "Royal Dream" sudah saya hapus)
    $gameProviders = [
        "Games"
    ];
    // ... (array provider lainnya tetap sama)
    $voucherProviders = [
            "Googleplay",
            "Unipin",
            "Razer Gold",
            "Garena Shells",
            "Megaxus",
            "Roblox",
            "Steam Wallet",
            "Playstation",
            "Alfamart",
            "Indomart",
            "Sushi Roll",
            "Tinder Plus",
            "Turbo VPN",
            "Unipin",
            "Xbox",
            "WeTV VIP",
            "VIU",
            "Vidio",
            "Garena Shell"
        ];
    $tagihanPulsaProviders = [
            "Pulsa", 
            "Ewallet", 
            "Paket Data",
            "Telp & Sms",
            "PLN", 
            "Token PLN", 
            "Token Listrik", 
            "Pascabayar", 
            "Voucher",
            "Tagihan",
            "Emoney",
            "Internet",
            "Lainnya"
        ];
    $sosmedProviders = [
            "Hago", 
            "Bigo Live", 
            "Bstation", 
            "Lita", 
            "Livu",
            "Likee",
            "Sugar Live",
            "Vidio",
            "VIU",
            "WeSing"
        ];

    // ## PERUBAHAN DI SINI: Buat array untuk melacak provider yang sudah ditampilkan ##
    $displayedProviders = [];

    function generateProductHTML($page) {
        return <<<HTML
        <a href="#" target="_blank">
            <button class="page">
                <img src="{$page['img_url']}" alt="Icon">
                <p>{$page['provider']}</p>
            </button>
        </a>
        HTML;
    }

    foreach ($data['data'] as $page) {
        // ## PERUBAHAN DI SINI: Cek apakah provider ini sudah pernah ditampilkan ##
        if (in_array($page['category'], $displayedProviders)) {
            continue; // Lewati ke iterasi berikutnya jika sudah ada
        }

        // Jika belum ada, proses seperti biasa
        if (in_array($page['provider'], $gameProviders)) {
            $productsHTML .= generateProductHTML($page);
            $displayedProviders[] = $page['category']; // Tandai provider ini sudah ditampilkan
        } elseif (in_array($page['category'], $voucherProviders)) {
            $products2HTML .= generateProductHTML($page);
            $displayedProviders[] = $page['category']; // Tandai provider ini sudah ditampilkan
        } elseif (in_array($page['category'], $tagihanPulsaProviders)) {
            $products3HTML .= generateProductHTML($page);
            $displayedProviders[] = $page['category']; // Tandai provider ini sudah ditampilkan
        } elseif (in_array($page['category'], $sosmedProviders)) {
            $products5HTML .= generateProductHTML($page);
            $displayedProviders[] = $page['category']; // Tandai provider ini sudah ditampilkan
        }
    }

} else {
    $errorMessage = 'Gagal mengambil data dari API.';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
<script src="https://kit.fontawesome.com/c2dbf73ff1.js" crossorigin="anonymous"></script>

<title><?php echo $nama_aplikasi; ?></title>
<style>
  @import url('https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,200;1,300;1,400;1,500;1,600;1,700;1,800&display=swap');

:root {
 --main: #f9f9f9;
 --subMain: {{warna_primary}};
 --subColor: #08e900;
 --bgIn: rgb(48, 56, 63) --white: #ffffff;
 --tabs: #4e4e4e;
 --borderColor: #636363;
 --animate-duration: 800ms;
 color: black;
 transition: background-color 0.5s, color 0.5s; 
}

body {
 font-family: 'Plus Jakarta Sans', sans-serif;
 background: var(--main);
 user-select: none;
 -moz-user-select: none;
 -ms-user-select: none;
 -khtml-user-select: none;
 -webkit-user-select: none;
 padding: 0;
 margin: 0;
 animation: fade-in 2s linear;
}
  #products,#products2,#products3,#products5{
    display: grid;
  grid-template-columns: repeat(4, 1fr); 
  gap: 5px;
  justify-content: center;
  text-align: center;
  }
  #products4{
    display: grid;
  grid-template-columns: repeat(2, 1fr); 
  gap: 10px;
  justify-content: center;
  text-align: center;
  }
  #products4 img{
    width: 30px !important;
    margin: 0px !important;
    border-radius: 0px;
    background: transparent;
  }
  #products4 p{
    margin: 0px !important;
  }
  .page{
    border: none;
    background: transparent;
    outline: none;
    overflow: hidden;
    border-radius: 10px;
    padding: 5px;
    
  }
  .page h2{
    font-size: 12px;
    text-align: center;
  }
  .page img{
    width: 100%;
    border-radius: 15px;
    padding: 0px;
    background: white;
    
  }
  .page p {
  font-size: 11px;
  margin-top: 10px;
  margin-bottom: 0;
  text-align: center;
}
  
  /* .header{
    background: var(--subMain);
    height: 140px;
    width: 100%;
    left:0;
    top: 0;
    z-index: -1;
    border-radius: 0px 0px 35% 35%;
    position: absolute;
  } */
  .box--wallet{
    background: white;
    padding: 15px;
    box-shadow: rgba(0, 0, 0, 0.16) 0px 1px 4px;
    margin-top: 15px;
    border-radius: 15px;
  }
  .saldo{
    display: flex;
    align-items: center;
    width: 100%;
    background: #f9f9f9;
    padding: 13px;
    border-radius: 15px;
  }
  .saldo img{
    width: 30px;
    margin-right: 10px;
  }
  .saldo h5{
    margin: 0;
    font-size: 14px;
    font-weight: bold;
  }
  .saldo p{
    font-size: 11px;
    margin: 0;
    color: var(--subMain);
    margin-top: 3px;
  }
  .nama_user{
    font-size: 15px;
    font-weight: 600;
    margin: 0;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
    width: 150px;
  }
  .tags--user p{
    font-size: 12px;
    margin: 0;
  }
  .icon--user{
    width: 35px;
    margin-right: 10px;
    border-radius: 12px;
  }
  .tab-container {
  overflow: hidden;
  background-color: #f1f1f1;
  position: relative;
  border-radius: 15px 15px 2px 2px;
  margin-bottom: 15px;
  display: flex;
}

.tab-btn {
  background-color: inherit;
  border: none;
  outline: none;
  cursor: pointer;
  padding: 14px 16px;
  transition: 0.3s;
  font-size: 11px;
  font-weight: 600;
width: 100%;
}

.tab-btn:hover {
  background-color: #ddd;
}

.slide {
  position: absolute;
  bottom: 0;
  height: 3px;
  background-color: var(--subMain); 
  transition: 0.3s;
  border: 2px;
}

.tab-content {
  display: none;
}

.tab-content h3 {
  margin-top: 0;
}
.box--gaming{
  background: white;
  border-radius: 15px;
  margin-top: 15px;
  box-shadow: rgba(0, 0, 0, 0.16) 0px 1px 4px;
  padding: 10px;
}
.dark-mode {
  background-color: #0f0f0f; /* Warna latar belakang mode gelap */
  color: #fff; /* Warna teks mode gelap */
}
.dark-mode .box--gaming{
  background-color: #181818; 
  color: #fff; 
}
.dark-mode .box--wallet{
  background-color: #181818; 
  color: #fff; 
}
.dark-mode .tab-container {
  background-color: #0f0e0e; 
}
.dark-mode .tab-btn {
  color: white;
  background-color: #0f0e0e; 
}
.dark-mode .saldo{
  background-color: #0f0e0e; 
  color: #fff; 
}
.dark-mode .box--gaming p{
  color: #fff; 
}
.dark-mode .box--wallet p{
  color: #fff; 
}
.dark-mode .box--gaming img{
  background-color: transparent; 
  color: #fff; 
}
.dark-mode .refresh--saldo img{
  filter: invert(100%) sepia(47%) saturate(2%) hue-rotate(338deg) brightness(110%) contrast(101%);
}
.dark-mode .tukar--poin img{
  filter: invert(100%) sepia(47%) saturate(2%) hue-rotate(338deg) brightness(110%) contrast(101%);
}
.dark-mode .wl--icon{
    filter: invert(100%) sepia(47%) saturate(2%) hue-rotate(338deg) brightness(110%) contrast(101%);
}
#darkModeToggle{
  border: none;
  background: transparent;
  outline: none;
  padding: 0;
}
#darkModeToggle img{
  width: 25px;
}
.header-sub {
        width: 100%;
        height: 60px;
        background-color: var(--subMain);
        color: white;
        position: fixed;
        top: -80px;
        left: 0;
        z-index: 999;
        padding:10px;
        transition: top 0.3s ease;
    }
    .header-sub.show {
        top: 0;
    }
    a{
      text-decoration: none;
    }
    .refresh--saldo{
      font-size: 12px;
      margin-left: 10px;
      margin-bottom: 0px !important;
      margin-top: 0px !important;
    }
    .tukar--poin {
      border: none;
      background: transparent;
      padding: 0;
    }
.btn--top{
  background: white;
  border: none;
  position: relative;
  margin-left: 5px;
  margin-right: 5px;
  border-radius: 100px;
  padding: 0 !important;
}
.btn--top img{
  width: 30px;
}
.btn--top span {
  position: absolute;
  top: -5px;
  right: -5px;
  font-size: 9px;
  background: red;
  border-radius: 100px;
  color: white;
  font-weight: bold;
  padding-left: 5px;
  padding-right: 5px;
  padding-top: 2px;
  padding-bottom: 1px;
}
a,a:focus,a:hover{
  text-decoration: none !important;
  outline: none !important;
  border: none !important;
  box-shadow: 0px 0px 0px 0px !important;
}
.dark-mode .topup img{
  filter: invert(100%) sepia(47%) saturate(2%) hue-rotate(338deg) brightness(110%) contrast(101%);
}
.dark-mode .topup p{
  font-size: 11px;
  color: white;
}
.topup{
  margin-top: 13px;
  margin-right: 10px;
  margin-left: 10px;
  text-align: center;
}
.topup img{
  width: 33px;
}
.topup p{
  font-size: 11px;
  color: black;
}
.tag--menu--gaming{
  font-size: 12px;
  font-weight: bold;
  margin-bottom: 0px;
  color: white;
  border-radius: 100px;
  background: var(--subMain);
  padding-right: 10px;
  padding-left: 10px;
  padding-top: 2px ;
  padding-bottom: 2px;
  margin-left: 10px;
}
</style>
</head>
<body>

<div class="header"></div>



<div class="container">
<div class="d-flex align-items-center mb-1 mt-2">
  <div class="w-100 tags--user">  
  <h5 class="nama_user"><?php echo $nama_aplikasi; ?></h5>
</div>
<a href="{{url_website_baru}}/akun/?page=notifikasi">
  <button class="btn--top">
    <img src="https://cdn-icons-png.flaticon.com/128/6131/6131835.png" alt="">
    <span id="notif_total">{{total_notif}}</span>
  </button>
</a>
</div>
</div>



<div class="header-sub d-none" style="display:none;">
  <div class="d-flex align-items-center mb-3">
    <img src="{{foto_profil}}" alt="" class="icon--user">
    <div class="w-100 tags--user">  
    <h5 class="nama_user w-100"><?php echo htmlspecialchars($user['username']); ?></h5>
    <p><?php echo htmlspecialchars($user['membership']); ?></p>
  </div>
  </div>
</div>


<div class="container">
<div class="box--wallet">
  <div class="d-flex align-items-center mb-3">
    <div class="w-100 tags--user">  
    <h5 class="nama_user">Hi,{{nama_user}}</h5>
  </div>
  <button id="darkModeToggle" style="margin-right: 10px;">
    <img id="darkModeIcon" src="https://cdn-icons-png.flaticon.com/128/1888/1888282.png" alt="Light Mode Icon"> 
    <span id="darkModeText"></span>
  </button>
  </div>
<div class="d-flex align-items-center" style="gap: 10px;">
<div class="saldo w-100">
  <div>
    <div class="d-flex align-items-center">
        <img src="https://cdn-icons-png.flaticon.com/128/9302/9302427.png" alt="" style="width: 18px;margin-right: 5px;" class="wl--icon">
  <h5 id="saldo">
    {{saldo_user}}
  </h5>
  <a href="{{url_website_baru}}/refresh_saldo" class="refresh--saldo">
    <img src="https://cdn-icons-png.flaticon.com/128/2680/2680215.png" style="width: 15px;" alt="">
  </a>
</div>
<a href="{{url_website_baru}}/akun/?page=convertpoin" class="d-flex align-items-center">
    <p id="poin">
     {{poin_member}}
    </p>
      <button class="tukar--poin">
        <img src="https://cdn-icons-png.flaticon.com/128/11488/11488622.png" style="width: 10px;margin-left: 10px;" alt="">
      </button>
    </a>
  </div>
</div>
<div class="d-flex align-items-center">
  <a href="{{url_website_baru}}/akun/?page=topup" class="text-center topup">
    <img src="https://cdn-icons-png.flaticon.com/128/10837/10837403.png" alt="">
    <p>Topup</p>
  </a>

<div id="products4"></div>
</div>
</div>
</div>
</div>
</div>


<!-- https://cdn.unipin.com/images/content_image_pages/1617089413-MA-210329-1-MY_UniPin_UMobile_RM1_Skin_700x280.jpg -->


<div class="container">
    <div class="box--gaming btn--hide">
      <div class="tab-container">
        <button class="tab-btn" onclick="openTab('tab1')" id="tab1Btn">
            <div class="d-flex align-items-center justify-content-center">
          <img src="https://cdn-icons-png.flaticon.com/128/10967/10967140.png" style="width: 17px;margin-right: 5px;" alt="">Populer
        </div>
        </button>
        <button class="tab-btn" onclick="openTab('tab2')" id="tab2Btn">Voucher</button>
        <button class="tab-btn" onclick="openTab('tab3')" id="tab3Btn">PPOB</button>
        <div class="slide" id="slider"></div>
      </div>
      <!-- List Menu 1 -->
      <div id="tab1" class="tab-content" style="display: none;">
        <div id="products">
          <?php echo $productsHTML ?: '<p>Tidak ada produk game yang tersedia.</p>'; ?>
        </div>
      </div>
      <div id="tab2" class="tab-content" style="display: none;">
        <div id="products2">
          <?php echo $products2HTML ?: '<p>Tidak ada produk game yang tersedia.</p>'; ?>
        </div>
      </div>
      <div id="tab3" class="tab-content" style="display: none;">
        <div id="products3">
          <?php echo $products3HTML ?: '<p>Tidak ada produk game yang tersedia.</p>'; ?>
        </div>
      </div>
    </div>
  </div>
  

<div class="container">
  <div class="box--gaming no-display">
    <div class="d-flex mt-2 mb-2 align-items-center">
    <p class="tag--menu--gaming">Streaming</p>
  </div>
    <div id="products5">
      <?php echo $products5HTML ?: '<p>Tidak ada produk game yang tersedia.</p>'; ?>
    </div>
</div>
</div>





<br/>

<script>
  const notifTotal = document.getElementById('notif_total');
  function updateNotificationText() {
    const total = parseInt(notifTotal.textContent);
    if (total > 100) {
      notifTotal.textContent = '99+';
    }
  }
  document.addEventListener('DOMContentLoaded', updateNotificationText);
</script>
<script>
  window.onscroll = function() {scrollFunction()};

  function scrollFunction() {
      if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
          document.getElementById("head-top").classList.add("show"); 
      } else {
          document.getElementById("head-top").classList.remove("show"); 
      }
  }
</script>
<script>
const darkModeToggle = document.getElementById('darkModeToggle');
const darkModeIcon = document.getElementById('darkModeIcon');
const body = document.body;

darkModeToggle.addEventListener('click', () => {
  body.classList.toggle('dark-mode');
  if (body.classList.contains('dark-mode')) {
    localStorage.setItem('darkMode', 'enabled');
    darkModeIcon.src = 'https://cdn-icons-png.flaticon.com/128/740/740878.png';
  } else {
    localStorage.setItem('darkMode', 'disabled');
    darkModeIcon.src = 'https://cdn-icons-png.flaticon.com/128/1888/1888282.png';
  }
});
document.addEventListener('DOMContentLoaded', () => {
  if (localStorage.getItem('darkMode') === 'enabled') {
    body.classList.add('dark-mode');
    darkModeIcon.src = 'https://cdn-icons-png.flaticon.com/128/740/740878.png';
  }
});

</script>

<script>
document.addEventListener("DOMContentLoaded", function() {
      openTab('tab1'); 

      // Menampilkan kembali elemen dengan class no-display jika bukan DEMO
      var noDisplayElements = document.getElementsByClassName("no-display");
      for (var i = 0; i < noDisplayElements.length; i++) {
        noDisplayElements[i].style.display = "block"; // Menampilkan kembali
      }
    
  });

  function openTab(tabName) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tab-content");
    for (i = 0; i < tabcontent.length; i++) {
      tabcontent[i].style.display = "none";
    }
    document.getElementById(tabName).style.display = "block";

    var tabBtns = document.getElementsByClassName("tab-btn");
    for (i = 0; i < tabBtns.length; i++) {
      tabBtns[i].style.backgroundColor = "inherit";
    }
    var clickedBtn = document.getElementById(tabName + "Btn");
    clickedBtn.style.backgroundColor = "transparent";

    var slider = document.getElementById("slider");
    slider.style.width = clickedBtn.offsetWidth + "px";
    slider.style.left = clickedBtn.offsetLeft + "px";
  }

</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
  // Data yang akan dikirim, sesuai dengan contoh baru Anda
  var data = "api_key=2IlkUzIHCJNNVu4g5oRoCcNxeUTaxP3tJngs7uOf8x6pOqAGwoI72aQ3Vn3nhEuXfonu0kzmIm14RRge5xqPuDCQIq8icJvEaYFU&type=prabayar";

  var xmlHttpRequest = new XMLHttpRequest();
  xmlHttpRequest.withCredentials = true;

  // URL diubah sesuai dengan Host baru: atlantich2h.com
  xmlHttpRequest.open("POST", "https://atlantich2h.com/layanan/price_list", true);
  xmlHttpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

  xmlHttpRequest.onreadystatechange = function () {
    if (this.readyState === 4) {
      var response = JSON.parse(this.responseText);
      
      // Asumsi: Struktur response dari endpoint baru ini tetap sama
      if (response.status === true) {

        // Filter pages for "Game Mobile Legends"
        var filteredPages1 = response.data.filter(function(page) {
          return [
            "Free Fire", "Pubg Mobile", "Mobile Legends", "Undawn", "Life After",
            "Call Of Duty", "Ragnarok M", "Ragnarok X", "Eggy Party", "Higgs Domino",
            "Royal Dream", "Bos Domino", "Metal Slug", "Valorant", "Bearfish",
            "Lol Wild Rift", "Ragnarok Origin", "Knives Out", "Arena Break Out",
            "8 Ball Pool", "Apex Legends", "Au2 Mobile", "Astral Guardians", "AOV",
            "Point Blank", "Badlanders", "Clash Royal", "Clash Of Clans", "COC",
            "Cloud Song", "Captain Tsubatsa", "Crisis Action", "Fairlight 84",
            "Growtopia", "Hay Day", "Honkai Impact 3", "Joy Domino", "Laplace M",
            "Lord Mobile", "Luna Fantasy", "Marvel Super War", "Marvel Snap",
            "Mu Origin 2", "One Punch Man", "Omega Legends", "Supersus",
            "Sausageman", "Super Mecha Champion", "Tom And Jerry", "Tower Of Fantasy",
            "ZEPETO", "Genshin Impact", "Speed Drifter", "HOK", "Honor Of Kings",
            "Royal Dream"
          ].includes(page.provider);
        });

        // Filter pages for "Voucher"
        var filteredPages2 = response.data.filter(function(page) {
          return [
            "Googleplay", "Unipin", "Razer Gold", "Garena Shells", "Megaxus",
            "Roblox", "Steam Wallet", "Playstation", "Alfamart", "Indomart",
            "Sushi Roll", "Tinder Plus", "Turbo VPN", "Xbox", "WeTV VIP",
            "VIU", "Vidio", "Garena Shell"
          ].includes(page.provider);
        });

        // Filter pages for "Tagihan & Pulsa"
        var filteredPages3 = response.data.filter(function(page) {
          return [
            "Pulsa", "Ewallet", "Paket Data", "Telp & Sms", "PLN", "Token PLN",
            "Token Listrik", "Pascabayar", "Voucher", "Tagihan", "Emoney",
            "Internet", "Lainnya"
          ].includes(page.provider);
        });

        // Filter pages for "Mutasi"
        /*var filteredPages4 = response.data.filter(function(page) {
          return ["Mutasi"].includes(page.provider);
        });*/

        // Filter pages for "Sosial Media"
        var filteredPages5 = response.data.filter(function(page) {
          return [
            "Hago", "Bigo Live", "Bstation", "Lita", "Livu", "Likee",
            "Sugar Live", "Vidio", "VIU", "WeSing"
          ].includes(page.provider);
        });
        
        displayPages(filteredPages1, "products"); 
        displayPages(filteredPages2, "products2");
        displayPages(filteredPages3, "products3");
        //displayPages(filteredPages4, "products4");
        displayPages(filteredPages5, "products5");

      } else {
        console.error("Error fetching data:", response.status);
      }
    }  
  };  
  
  xmlHttpRequest.send(data);

  function displayPages(pages, containerId) {
    var pagesContainer = document.getElementById(containerId);
    var pagesHTML = "";
    pages.forEach(function(page) {
      pagesHTML += `
      <a href="#" target="_blank">
        <button class="page">
          <img src="${page.img_url}" alt="Icon">
          <p>${page.provider}</p>
        </button>
      </a>
      `;
    });
    pagesContainer.innerHTML = pagesHTML;
  }
});
</script>
<script>
function rubah(angka) {
  var reverse = angka.toString().split('').reverse().join(''),
    ribuan = reverse.match(/\d{1,3}/g);
  ribuan = ribuan.join('.').split('').reverse().join('');
  return "Rp" + ribuan;
}
document.getElementById("saldo").innerText = rubah(document.getElementById("saldo").textContent)
</script>
<script>
  function rubah(angka) {
    var reverse = angka.toString().split('').reverse().join(''),
      ribuan = reverse.match(/\d{1,3}/g);
    ribuan = ribuan.join('.').split('').reverse().join('');
    return "Poin : " + ribuan;
  }
  document.getElementById("poin").innerText = rubah(document.getElementById("poin").textContent)
  </script>
<script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js" integrity="sha384-JqMkTJhi4V4o0jFTx0Kr+k4IoW/6TE9w6SbPJF51cXKfX+lJZ8tu8cvpIdH9UvLZ" crossorigin="anonymous"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous"></script>
</body>
</html>
