<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />

    <!--favicon icon-->
    <link rel="icon" href="assets/img/favicon.png" type="image/png" sizes="16x16"/>

    <!--title-->
    <title>Domain Search - Modern Web Hosting & WHMCS Template</title>

    <!--build:css-->
    <link href="assets/css/main-rtl.css" as="style" rel="stylesheet"/>
    <!-- endbuild -->
  </head>

  <body>
    <!--preloader start-->
<div id="preloader">
    <div class="preloader-wrap">
        <img src="assets/img/logo-color.png" alt="logo" class="img-fluid"/>
        <div class="preloader">
            <i>.</i>
            <i>.</i>
            <i>.</i>
        </div>
    </div>
</div>
<!--preloader end--> 
<!--header section start-->
<header id="header" class="header-main">
  <!--main header menu start-->
  <div id="logoAndNav" class="main-header-menu-wrap bg-transparent fixed-top">
    <div class="container">
      <nav class="js-mega-menu navbar navbar-expand-md header-nav">
        <!--logo start-->
        <a class="navbar-brand pt-0" href="index.html">
          <img src="assets/img/logo-white.png" alt="logo" />
        </a>
        <!--logo end-->

        <!--responsive toggle button start-->
        <button
          type="button"
          class="navbar-toggler btn"
          data-bs-toggle="offcanvas"
          data-bs-target="#offcanvasLeft"
        >
          <span id="hamburgerTrigger">
            <span class="fas fa-bars"></span>
          </span>
        </button>
        <!--responsive toggle button end-->

        <!--main menu start-->
        <div id="navBar" class="collapse navbar-collapse">
          <ul class="navbar-nav ms-auto main-navbar-nav">
            <!--home start-->
            <li
              class="nav-item hs-has-mega-menu custom-nav-item"
              data-position="center"
            >
              <a
                id="homeMegaMenu"
                class="nav-link custom-nav-link main-link-toggle"
                href="javascript:void(0);"
                aria-haspopup="true"
                aria-expanded="false"
              >
                Home
              </a>
              <!--home mega menu start-->
              <div
                class="hs-mega-menu main-sub-menu w-100"
                aria-labelledby="homeMegaMenu"
              >
                <div class="row g-0">
                  <div
                    class="col-lg-5 col-sm-6 col-12 gray-light-bg custom-radius-left"
                  >
                    <div class="menu-item-wrap p-4">
                      <h6>#1 Web Hosting Company</h6>
                      <p>
                        Get your website, web store or application online using
                        our reliable and fast hosting.
                      </p>
                      <ul class="list-unstyled content-feature-list mb-2">
                        <li>
                          <i class="fas fa-check-circle text-success pe-2"></i>
                          Managed cloud
                        </li>
                        <li>
                          <i class="fas fa-check-circle text-success pe-2"></i>
                          Business continuity
                        </li>
                        <li>
                          <i class="fas fa-check-circle text-success pe-2"></i>
                          IT/Cloud consultancy
                        </li>
                        <li>
                          <i class="fas fa-check-circle text-success pe-2"></i>
                          Load and stress testing
                        </li>
                        <li>
                          <i class="fas fa-check-circle text-success pe-2"></i>
                          Managed Kubernetes
                        </li>
                        <li>
                          <i class="fas fa-check-circle text-success pe-2"></i>
                          Managed Multi-datacenter
                        </li>
                      </ul>
                    </div>
                  </div>
                  <div class="col-lg-7 col-sm-6 col-12 custom-radius-right">
                    <div class="row no-gutters p-4">
                      <div class="col-sm-12">
                        <span class="sub-menu-title">Home different style</span>
                        <ul class="home-demo-list">
                          <li>
                            <a href="index.html">
                              <i class="far fa-hard-drive me-2"></i>
                              Home Default
                            </a>
                          </li>
                          <li>
                            <a href="index-image.html">
                              <i class="far fa-file-image me-2"></i>
                              Home Image
                            </a>
                          </li>
                          <li>
                            <a href="index-slider.html">
                              <i class="far fa-clone me-2"></i>
                              Home Content Slider
                            </a>
                          </li>
                          <li>
                            <a href="index-gaming.html">
                              <i class="far fa-gem me-2"></i>
                              Home Gaming Hosting
                            </a>
                          </li>
                          <li>
                            <a href="index-video.html">
                              <i class="far fa-file-video me-2"></i>
                              Home Background Video
                            </a>
                          </li>
                          <li>
                            <a href="index-black-friday.html">
                              <i class="far fa-lightbulb me-2"></i>
                              Home Black Friday Sale
                            </a>
                          </li>
                          <li>
                            <a href="index-black-friday-coming.html">
                              <i class="far fa-circle-dot me-2"></i>
                              Home Black Friday Coming
                            </a>
                          </li>
                          <li>
                            <a href="index-top-navbar.html">
                              <i class="far fa-hard-drive me-2"></i>
                              Home Top Navbar
                            </a>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div>
                  <div class="col-12">
                    <!-- Mega Menu Banner -->
                    <div class="u-header__product-banner">
                      <div
                        class="u-header__product-banner-content text-center text-white"
                      >
                        <div class="mb-4">
                          <h5 class="text-white">Get 25% Discount Start Now</h5>
                          <ul
                            class="list-unstyled list-inline menu-countdown my-4"
                          >
                            <li class="list-inline-item mb-0">
                              <span
                                class="counter-days border border-light fs-sm text-light p-2 rounded fw-medium"
                              ></span>
                            </li>
                            <li class="list-inline-item mb-0">
                              <span
                                class="counter-hours border border-light fs-sm text-light p-2 rounded fw-medium"
                              ></span>
                            </li>
                            <li class="list-inline-item mb-0">
                              <span
                                class="counter-minutes border border-light fs-sm text-light p-2 rounded fw-medium"
                              ></span>
                            </li>
                            <li class="list-inline-item mb-0">
                              <span
                                class="counter-seconds border border-light fs-sm text-light p-2 rounded fw-medium"
                              ></span>
                            </li>
                          </ul>
                        </div>
                        <a class="btn btn-tertiary mt-2" href="#">
                          Get start now
                          <span class="fas fa-arrow-right ps-2"></span>
                        </a>
                      </div>
                    </div>
                    <!-- End Mega Menu Banner -->
                  </div>
                </div>
              </div>
              <!--home mega menu end-->
            </li>
            <!--home end-->
            <!--pages start-->
            <li class="nav-item hs-has-sub-menu custom-nav-item">
              <a
                id="pagesMegaMenu"
                class="nav-link custom-nav-link main-link-toggle"
                href="javascript:void(0);"
                aria-haspopup="true"
                aria-expanded="false"
                aria-labelledby="pagesSubMenu"
              >
                Pages
              </a>
              <!-- Pages - Submenu -->
              <ul
                id="pagesSubMenu"
                class="hs-sub-menu main-sub-menu"
                aria-labelledby="pagesMegaMenu"
                style="min-width: 230px;"
              >
                <li class="nav-item submenu-item">
                  <a class="nav-link sub-menu-nav-link" href="about-us.html">
                    About Us
                  </a>
                </li>
                <li class="nav-item submenu-item">
                  <a
                    class="nav-link sub-menu-nav-link"
                    href="offer-single-page.html"
                  >
                    Black Friday Single
                  </a>
                </li>
                <li class="nav-item submenu-item">
                  <a
                    class="nav-link sub-menu-nav-link"
                    href="terms-condition.html"
                  >
                    Terms & Condition
                  </a>
                </li>
                <li class="nav-item submenu-item">
                  <a
                    class="nav-link sub-menu-nav-link"
                    href="privacy-policy.html"
                  >
                    Privacy Policy
                  </a>
                </li>
                <li class="hs-has-sub-menu">
                  <a
                    id="navLinkPagesPricing"
                    class="nav-link sub-menu-nav-link sub-link-toggle"
                    href="javascript:void(0);"
                    aria-haspopup="true"
                    aria-expanded="false"
                    aria-controls="navSubmenuPagesPricing"
                  >
                    Pricing
                  </a>
                  <ul
                    id="navSubmenuPagesPricing"
                    class="hs-sub-menu main-sub-menu"
                    aria-labelledby="navLinkPagesPricing"
                    style="min-width: 230px;"
                  >
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="pricing-default.html"
                      >
                        Pricing Default
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="pricing-package.html"
                      >
                        Pricing Packages
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="pricing-web-hosting.html"
                      >
                        Web Hosting Packages
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="pricing-windows-hosting.html"
                      >
                        Windows Hosting
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="pricing-comparision.html"
                      >
                        Pricing Comparison
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="pricing-specifications.html"
                      >
                        Pricing Specifications
                        <span class="badge bg-danger ms-auto">New</span>
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="vps-pricing.html"
                      >
                        VPS Pricing
                      </a>
                    </li>
                  </ul>
                </li>
                <li class="hs-has-sub-menu">
                  <a
                    id="navLinkPagesBlog"
                    class="nav-link sub-menu-nav-link sub-link-toggle"
                    href="javascript:void(0);"
                    aria-haspopup="true"
                    aria-expanded="false"
                    aria-controls="navSubmenuPagesBlog"
                  >
                    Blog
                  </a>
                  <ul
                    id="navSubmenuPagesBlog"
                    class="hs-sub-menu main-sub-menu"
                    aria-labelledby="navLinkPagesBlog"
                    style="min-width: 230px;"
                  >
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="blog-grid.html"
                      >
                        Blog Grid
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="blog-details.html"
                      >
                        Blog Details
                      </a>
                    </li>
                  </ul>
                </li>
                <li class="hs-has-sub-menu">
                  <a
                    id="navLinkPagesSpecialty"
                    class="nav-link sub-menu-nav-link sub-link-toggle"
                    href="javascript:void(0);"
                    aria-haspopup="true"
                    aria-expanded="false"
                    aria-controls="navSubmenuPagesSpecialty"
                  >
                    Specialty
                  </a>
                  <ul
                    id="navSubmenuPagesSpecialty"
                    class="hs-sub-menu main-sub-menu"
                    aria-labelledby="navLinkPagesSpecialty"
                    style="min-width: 230px;"
                  >
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="domain-search-result.html"
                      >
                        Search Result
                        <span class="badge bg-success ms-2">New</span>
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="cover-page.html"
                      >
                        Cover Page
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="coming-soon.html"
                      >
                        Coming Soon
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="thank-you.html"
                      >
                        Thank You
                      </a>
                    </li>
                    <li>
                      <a class="nav-link sub-menu-nav-link" href="404.html">
                        Error 404
                      </a>
                    </li>
                  </ul>
                </li>
                <li class="hs-has-sub-menu">
                  <a
                    id="navLinkPagesLogin"
                    class="nav-link sub-menu-nav-link sub-link-toggle"
                    href="javascript:void(0);"
                    aria-haspopup="true"
                    aria-expanded="false"
                    aria-controls="navSubmenuPagesLogin"
                  >
                    Login &amp; Signup
                  </a>
                  <ul
                    id="navSubmenuPagesLogin"
                    class="hs-sub-menu main-sub-menu"
                    aria-labelledby="navLinkPagesLogin"
                    style="min-width: 230px;"
                  >
                    <li>
                      <a class="nav-link sub-menu-nav-link" href="login.html">
                        Login
                      </a>
                    </li>
                    <li>
                      <a class="nav-link sub-menu-nav-link" href="sign-up.html">
                        Signup
                      </a>
                    </li>
                    <li>
                      <a
                        class="nav-link sub-menu-nav-link"
                        href="password-reset.html"
                      >
                        Recover Account
                      </a>
                    </li>
                  </ul>
                </li>
              </ul>
              <!-- End Pages - Submenu -->
            </li>
            <!--pages end-->
            <!--hosting start-->
            <li
              class="nav-item hs-has-mega-menu custom-nav-item position-relative"
              data-position="center"
            >
              <a
                id="hostingMegaMenu"
                class="nav-link custom-nav-link main-link-toggle"
                href="JavaScript:Void(0);"
                aria-haspopup="true"
                aria-expanded="false"
              >
                Hosting
              </a>
              <!-- Demos - Mega Menu -->
              <div
                class="hs-mega-menu main-sub-menu"
                style="width: 715px;"
                aria-labelledby="hostingMegaMenu"
              >
                <div class="row g-0">
                  <div class="col-md-6">
                    <div class="menu-item-wrap py-0 p-md-3 p-lg-3">
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a
                          class="title-with-icon-link"
                          href="shared-hosting.html"
                        >
                          <div class="d-flex align-items-center">
                            <div class="menu-item-icon pe-3">
                              <i
                                class="fas fa-server rounded-circle primary-bg"
                              ></i>
                            </div>
                            <div class="media-body">
                              <span class="u-header__promo-title">
                                Shared Web Hosting
                              </span>
                              <small class="u-header__promo-text">
                                Reliable quality Starting at
                                <strong>$2.99</strong>
                              </small>
                            </div>
                          </div>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a class="title-with-icon-link" href="vps-hosting.html">
                          <div class="d-flex align-items-center">
                            <div class="menu-item-icon pe-3">
                              <i
                                class="fas fa-box rounded-circle accent-bg"
                              ></i>
                            </div>
                            <div class="media-body">
                              <span class="u-header__promo-title">
                                VPS Hosting
                              </span>
                              <small class="u-header__promo-text">
                                Maintain Starting at
                                <strong>$11.99</strong>
                              </small>
                            </div>
                          </div>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a
                          class="title-with-icon-link"
                          href="cloud-hosting.html"
                        >
                          <div class="d-flex align-items-center">
                            <div class="menu-item-icon pe-3">
                              <i
                                class="fas fa-cloud rounded-circle secondary-bg"
                              ></i>
                            </div>
                            <div class="media-body">
                              <span class="u-header__promo-title">
                                Cloud Hosting
                              </span>
                              <small class="u-header__promo-text">
                                Cloud Starting at
                                <strong>$5.99/mo</strong>
                              </small>
                            </div>
                          </div>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="menu-item-wrap py-0 p-md-3 p-lg-3">
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a
                          class="title-with-icon-link"
                          href="email-hosting.html"
                        >
                          <div class="d-flex align-items-center">
                            <div class="menu-item-icon pe-3">
                              <i
                                class="fas fa-envelope rounded-circle twitter-bg"
                              ></i>
                            </div>
                            <div class="media-body">
                              <span class="u-header__promo-title">
                                Email Hosting
                              </span>
                              <small class="u-header__promo-text">
                                First Starting at
                                <strong>$0.99/mo</strong>
                              </small>
                            </div>
                          </div>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a
                          class="title-with-icon-link"
                          href="windows-vps-hosting.html"
                        >
                          <div class="d-flex align-items-center">
                            <div class="menu-item-icon pe-3">
                              <i
                                class="fab fa-windows rounded-circle bg-success"
                              ></i>
                            </div>
                            <div class="media-body">
                              <span class="u-header__promo-title">
                                Windows VPS Hosting
                              </span>
                              <small class="u-header__promo-text">
                                Globally Starting at
                                <strong>$9.99/mo</strong>
                              </small>
                            </div>
                          </div>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a
                          class="title-with-icon-link"
                          href="dedicated-server-hosting.html"
                        >
                          <div class="d-flex align-items-center">
                            <div class="menu-item-icon pe-3">
                              <i
                                class="fas fa-database rounded-circle dribbble-bg"
                              ></i>
                            </div>
                            <div class="media-body">
                              <span class="u-header__promo-title">
                                Dedicated Server Hosting
                              </span>
                              <small class="u-header__promo-text">
                                Conveniently Starting at
                                <strong>$9.99/mo</strong>
                              </small>
                            </div>
                          </div>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                    </div>
                  </div>
                </div>
                <!--application hosting start-->
                <div class="application-hosting text-white">
                  <span
                    class="sub-menu-title text-lg-center text-md-center text-white mb-3"
                  >
                    Application For Hosting
                  </span>
                  <ul class="application-hosting-list">
                    <li>
                      <a href="wp-hosting.html">
                        <img
                          src="assets/img/icons/wordpress-icon-color.svg"
                          alt="icon"
                        />
                        WordPress Hosting
                      </a>
                    </li>
                    <li>
                      <a href="joomla-hosting.html">
                        <img
                          src="assets/img/icons/joomla-icon-color.svg"
                          alt="icon"
                        />
                        Joomla Hosting
                      </a>
                    </li>
                    <li>
                      <a href="magento-hosting.html">
                        <img
                          src="assets/img/icons/magento-icon-color.svg"
                          alt="icon"
                        />
                        Magento Hosting
                      </a>
                    </li>
                    <li>
                      <a href="opencart-hosting.html">
                        <img
                          src="assets/img/icons/opencart-icon-color.svg"
                          alt="icon"
                        />
                        Opencart Hosting
                      </a>
                    </li>
                    <li>
                      <a href="prestashop-hosting.html">
                        <img
                          src="assets/img/icons/prestashop-icon-color.svg"
                          alt="icon"
                        />
                        Prestashop Hosting
                      </a>
                    </li>
                    <li>
                      <a href="drupal-hosting.html">
                        <img
                          src="assets/img/icons/drupal-icon-color.svg"
                          alt="icon"
                        />
                        Drupal Hosting
                      </a>
                    </li>
                  </ul>
                </div>
                <!--application hosting end-->
              </div>
              <!-- End Demos - Mega Menu -->
            </li>
            <!--hosting end-->
            <!--domain start-->
            <li
              class="nav-item hs-has-mega-menu custom-nav-item position-relative"
              data-position="center"
            >
              <a
                id="domainMegaMenu"
                class="nav-link custom-nav-link main-link-toggle"
                href="JavaScript:Void(0);"
                aria-haspopup="true"
                aria-expanded="false"
              >
                Domain
              </a>
              <!-- Demos - Mega Menu -->
              <div
                class="hs-mega-menu main-sub-menu"
                style="width: 660px;"
                aria-labelledby="domainMegaMenu"
              >
                <div class="row g-0">
                  <div class="col-md-6 col-sm-6">
                    <div class="menu-item-wrap p-3">
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a
                          class="title-with-icon-link"
                          href="domain-checker.html"
                        >
                          <div class="d-flex align-items-center pb-1">
                            <i class="fas fa-globe me-2 color-primary"></i>
                            <span class="u-header__promo-title">
                              Domain Checker
                            </span>
                          </div>
                          <small class="u-header__promo-text">
                            Find the perfect domain for your business
                          </small>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a
                          class="title-with-icon-link"
                          href="domain-transfer.html"
                        >
                          <div class="d-flex align-items-center pb-1">
                            <i
                              class="fas fa-exchange-alt me-2 color-accent"
                            ></i>
                            <span class="u-header__promo-title">
                              Domain Transfer
                            </span>
                          </div>
                          <small class="u-header__promo-text">
                            Transfer your domain easily
                          </small>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                      <!--menu title with subtitle and icon item start-->
                      <div class="title-with-icon-item">
                        <a
                          class="title-with-icon-link"
                          href="domain-registration.html"
                        >
                          <div class="d-flex align-items-center pb-1">
                            <i
                              class="fas fa-copyright me-2 instagram-color"
                            ></i>
                            <span class="u-header__promo-title">
                              Domain Registration
                            </span>
                          </div>
                          <small class="u-header__promo-text">
                            Register your domain name for lifetime
                          </small>
                        </a>
                      </div>
                      <!--menu title with subtitle and icon item end-->
                    </div>
                  </div>
                  <div
                    class="col-md-6 col-sm-6 gray-light-bg custom-radius-right"
                  >
                    <div class="menu-item-wrap p-4">
                      <h6>#1 Web Hosting Company</h6>
                      <ul class="list-unstyled tech-feature-list">
                        <li class="py-1">
                          <small>
                            <span
                              class="fas fa-check-circle text-success me-2"
                            ></span>
                            <strong>Flexible</strong>
                            Easy to Use Control Panel
                          </small>
                        </li>
                        <li class="py-1">
                          <small>
                            <span
                              class="fas fa-check-circle text-success me-2"
                            ></span>
                            <strong>99%</strong>
                            Uptime Guarantee
                          </small>
                        </li>
                        <li class="py-1">
                          <small>
                            <span
                              class="fas fa-check-circle text-success me-2"
                            ></span>
                            <strong>45-Day</strong>
                            Money-Back Guarantee
                          </small>
                        </li>
                        <li class="py-1">
                          <small>
                            <span
                              class="fas fa-check-circle text-success me-2"
                            ></span>
                            <strong>Free SSL</strong>
                            Certificate Included
                          </small>
                        </li>
                      </ul>
                      <a class="btn btn-tertiary btn-block mt-3" href="#">
                        Learn More
                        <span class="fas fa-angle-right ms-2"></span>
                      </a>
                    </div>
                  </div>
                </div>
              </div>
              <!-- End Demos - Mega Menu -->
            </li>
            <!--domain end-->
            <li class="nav-item custom-nav-item">
              <a class="nav-link custom-nav-link" href="affiliates.html">
                Affiliates
              </a>
            </li>
            <!--about start-->
            <li
              class="nav-item hs-has-mega-menu custom-nav-item position-relative"
              data-position="center"
            >
              <a
                id="aboutMegaMenu"
                class="nav-link custom-nav-link main-link-toggle"
                href="JavaScript:Void(0);"
                aria-haspopup="true"
                aria-expanded="false"
              >
                Company
              </a>
              <!--about submenu start-->
              <div
                class="hs-mega-menu main-sub-menu"
                style="width: 320px;"
                aria-labelledby="aboutMegaMenu"
              >
                <!--menu title with subtitle and icon item start-->
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="contact-us.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/chat-mobile.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">Contact Us</span>
                        <small class="u-header__promo-text">
                          Face any problem contact with us
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <!--menu title with subtitle and icon item end-->
                <!--menu title with subtitle and icon item start-->
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="about-us.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/community.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">About Us</span>
                        <small class="u-header__promo-text">
                          We are leading hosting company
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <!--menu title with subtitle and icon item end-->
                <!--menu title with subtitle and icon item start-->
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="partners.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/partner.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">Our Partner</span>
                        <small class="u-header__promo-text">
                          We have trusted partners globally
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <!--menu title with subtitle and icon item end-->
                <!--menu title with subtitle and icon item start-->
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="network.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/network.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">Network</span>
                        <small class="u-header__promo-text">
                          Keep your data save and secure
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <!--menu title with subtitle and icon item end-->
                <!--menu title with subtitle and icon item start-->
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="blog-grid.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/blog.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">Company Blog</span>
                        <small class="u-header__promo-text">
                          Industry latest technology news & tips
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <!--menu title with subtitle and icon item end-->
              </div>
              <!--about submenu end-->
            </li>
            <!--about end-->
            <!--button start-->
            <li class="nav-item header-nav-last-item d-flex align-items-center">
              <a
                class="btn btn-tertiary animated-btn"
                href="https://whmcs.themetags.com/index.php?systpl=kohost&carttpl=themetags_cart" target="_blank">
                <span class="fa fa-user pe-2"></span>
                Client Area
              </a>
            </li>
            <!--button end-->
          </ul>
        </div>
        <!--main menu end-->
      </nav>
    </div>
  </div>
  <!--main header menu end-->

  <!--offcanvas menu start-->
  <div class="offcanvas offcanvas-start" id="offcanvasLeft" tabindex="-1">
    <div class="offcanvas-header border-bottom">
      <a class="navbar-brand" href="index.html">
        <img
          src="assets/img/logo-color.png"
          alt="logo"
          class="img-fluid"
        />
      </a>
      <button
        class="btn-close"
        type="button"
        data-bs-dismiss="offcanvas"
      ></button>
    </div>
    <div class="offcanvas-body offcanvas-menu-wrap">
      <!--offcanvas menu list start-->
      <ul class="navbar-nav">
        <!--home item start-->
        <li class="nav-item dropdown">
          <a
            class="nav-link dropdown-toggle"
            href="#"
            data-bs-toggle="dropdown"
          >
            Home
          </a>
          <div class="dropdown-menu p-0">
            <div class="row g-0">
              <div class="col-12 gray-light-bg">
                <div class="menu-item-wrap p-4">
                  <h6>#1 Web Hosting Company</h6>
                  <p>
                    Get your website, web store or application online using our
                    reliable and fast hosting.
                  </p>
                  <ul class="list-unstyled content-feature-list mb-2">
                    <li>
                      <i class="fas fa-check-circle text-success pe-2"></i>
                      Managed cloud
                    </li>
                    <li>
                      <i class="fas fa-check-circle text-success pe-2"></i>
                      Business continuity
                    </li>
                    <li>
                      <i class="fas fa-check-circle text-success pe-2"></i>
                      IT/Cloud consultancy
                    </li>
                    <li>
                      <i class="fas fa-check-circle text-success pe-2"></i>
                      Load and stress testing
                    </li>
                    <li>
                      <i class="fas fa-check-circle text-success pe-2"></i>
                      Managed Kubernetes
                    </li>
                    <li>
                      <i class="fas fa-check-circle text-success pe-2"></i>
                      Managed Multi-datacenter
                    </li>
                  </ul>
                </div>
              </div>
              <div class="col-12">
                <div class="row no-gutters p-4">
                  <div class="col-sm-12">
                    <span class="sub-menu-title">Home different style</span>
                    <ul class="home-demo-list">
                      <li>
                        <a href="index.html">
                          <i class="far fa-hard-drive me-2"></i>
                          Home Default
                        </a>
                      </li>
                      <li>
                        <a href="index-image.html">
                          <i class="far fa-file-image me-2"></i>
                          Home Image
                        </a>
                      </li>
                      <li>
                        <a href="index-slider.html">
                          <i class="far fa-clone me-2"></i>
                          Home Content Slider
                        </a>
                      </li>
                      <li>
                        <a href="index-gaming.html">
                          <i class="far fa-gem me-2"></i>
                          Home Gaming Hosting
                        </a>
                      </li>
                      <li>
                        <a href="index-video.html">
                          <i class="far fa-file-video me-2"></i>
                          Home Background Video
                        </a>
                      </li>
                      <li>
                        <a href="index-black-friday.html">
                          <i class="far fa-lightbulb me-2"></i>
                          Home Black Friday Sale
                        </a>
                      </li>
                      <li>
                        <a href="index-black-friday-coming.html">
                          <i class="far fa-circle-dot me-2"></i>
                          Home Black Friday Coming
                        </a>
                      </li>
                      <li>
                        <a href="index-top-navbar.html">
                          <i class="far fa-hard-drive me-2"></i>
                          Home Top Navbar
                        </a>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
              <div class="col-12">
                <!-- Mega Menu Banner -->
                <div class="u-header__product-banner">
                  <div
                    class="u-header__product-banner-content text-center text-white"
                  >
                    <div class="mb-4">
                      <h5 class="text-white">Get 25% Discount Start Now</h5>
                      <ul class="list-unstyled list-inline menu-countdown my-4">
                        <li class="list-inline-item mb-0">
                          <span
                            class="counter-days border border-light fs-sm text-light p-2 rounded fw-medium"
                          ></span>
                        </li>
                        <li class="list-inline-item mb-0">
                          <span
                            class="counter-hours border border-light fs-sm text-light p-2 rounded fw-medium"
                          ></span>
                        </li>
                        <li class="list-inline-item mb-0">
                          <span
                            class="counter-minutes border border-light fs-sm text-light p-2 rounded fw-medium"
                          ></span>
                        </li>
                        <li class="list-inline-item mb-0">
                          <span
                            class="counter-seconds border border-light fs-sm text-light p-2 rounded fw-medium"
                          ></span>
                        </li>
                      </ul>
                    </div>
                    <a class="btn btn-tertiary mt-2" href="#">
                      Get start now
                      <span class="fas fa-arrow-right ps-2"></span>
                    </a>
                  </div>
                </div>
                <!-- End Mega Menu Banner -->
              </div>
            </div>
          </div>
        </li>
        <!--home item end-->

        <!--page item start-->
        <li class="nav-item dropdown">
          <a
            class="nav-link dropdown-toggle"
            href="#"
            data-bs-toggle="dropdown"
            data-bs-auto-close="outside"
          >
            Pages
          </a>
          <ul class="dropdown-menu">
            <li>
              <a class="dropdown-item" href="about-us.html">About Us</a>
            </li>
            <li>
              <a class="dropdown-item" href="offer-single-page.html">
                Black Friday Single
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="terms-condition.html">
                Terms & Condition
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="privacy-policy.html">
                Privacy Policy
              </a>
            </li>
            <li class="dropdown">
              <a
                class="dropdown-item dropdown-toggle"
                href="#"
                data-bs-toggle="dropdown"
              >
                Pricing
              </a>
              <ul class="dropdown-menu">
                <li>
                  <a class="dropdown-item" href="pricing-default.html">
                    Pricing Default
                  </a>
                </li>
                <li>
                  <a class="dropdown-item" href="pricing-package.html">
                    Pricing Packages
                  </a>
                </li>
                <li>
                  <a class="dropdown-item" href="pricing-web-hosting.html">
                    Web Hosting Packages
                  </a>
                </li>
                <li>
                  <a class="dropdown-item" href="pricing-windows-hosting.html">
                    Windows Hosting
                  </a>
                </li>
                <li>
                  <a class="dropdown-item" href="pricing-comparision.html">
                    Pricing Comparison
                  </a>
                </li>
                <li>
                  <a class="dropdown-item" href="pricing-specifications.html">
                    Pricing Specifications
                    <span class="badge bg-danger ms-auto">New</span>
                  </a>
                </li>
                <li>
                  <a class="dropdown-item" href="vps-pricing.html">
                    VPS Pricing
                  </a>
                </li>
              </ul>
            </li>

            <li class="dropdown">
              <a
                class="dropdown-item dropdown-toggle"
                href="#"
                data-bs-toggle="dropdown"
              >
                Blog
              </a>
              <ul class="dropdown-menu">
                <li>
                  <a class="dropdown-item" href="blog-grid.html">Blog Grid</a>
                </li>
                <li>
                  <a class="dropdown-item" href="blog-details.html">
                    Blog Details
                  </a>
                </li>
              </ul>
            </li>

            <li class="dropdown">
              <a
                class="dropdown-item dropdown-toggle"
                href="#"
                data-bs-toggle="dropdown"
              >
                Specialty
              </a>
              <ul class="dropdown-menu">
                <li>
                  <a class="dropdown-item" href="domain-search-result.html">
                    Search Result
                    <span class="badge bg-success ms-2">New</span>
                  </a>
                </li>
                <li>
                  <a class="dropdown-item" href="cover-page.html">Cover Page</a>
                </li>
                <li>
                  <a class="dropdown-item" href="coming-soon.html">
                    Coming Soon
                  </a>
                </li>
                <li>
                  <a class="dropdown-item" href="thank-you.html">Thank You</a>
                </li>
                <li>
                  <a class="dropdown-item" href="404.html">Error 404</a>
                </li>
              </ul>
            </li>

            <li class="dropdown">
              <a
                class="dropdown-item dropdown-toggle"
                href="#"
                data-bs-toggle="dropdown"
              >
                Login and Signup
              </a>
              <ul class="dropdown-menu">
                <li>
                  <a class="dropdown-item" href="login.html">Login</a>
                </li>
                <li>
                  <a class="dropdown-item" href="sign-up.html">Signup</a>
                </li>
                <li>
                  <a class="dropdown-item" href="password-reset.html">
                    Recover Account
                  </a>
                </li>
              </ul>
            </li>
          </ul>
        </li>
        <!--page item end-->

        <!--hosting item start-->
        <li class="nav-item dropdown">
          <a
            class="nav-link dropdown-toggle"
            href="#"
            data-bs-toggle="dropdown"
          >
            Hosting
          </a>
          <div class="dropdown-menu p-0">
            <div class="row g-0">
              <div class="col-12">
                <div class="menu-item-wrap py-0 p-md-3 p-lg-3">
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a class="title-with-icon-link" href="shared-hosting.html">
                      <div class="d-flex align-items-center">
                        <div class="menu-item-icon pe-3">
                          <i
                            class="fas fa-server rounded-circle primary-bg"
                          ></i>
                        </div>
                        <div class="media-body">
                          <span class="u-header__promo-title">
                            Shared Web Hosting
                          </span>
                          <small class="u-header__promo-text">
                            Reliable quality Starting at
                            <strong>$2.99</strong>
                          </small>
                        </div>
                      </div>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a class="title-with-icon-link" href="vps-hosting.html">
                      <div class="d-flex align-items-center">
                        <div class="menu-item-icon pe-3">
                          <i class="fas fa-box rounded-circle accent-bg"></i>
                        </div>
                        <div class="media-body">
                          <span class="u-header__promo-title">VPS Hosting</span>
                          <small class="u-header__promo-text">
                            Maintain Starting at
                            <strong>$11.99</strong>
                          </small>
                        </div>
                      </div>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a class="title-with-icon-link" href="cloud-hosting.html">
                      <div class="d-flex align-items-center">
                        <div class="menu-item-icon pe-3">
                          <i
                            class="fas fa-cloud rounded-circle secondary-bg"
                          ></i>
                        </div>
                        <div class="media-body">
                          <span class="u-header__promo-title">
                            Cloud Hosting
                          </span>
                          <small class="u-header__promo-text">
                            Cloud Starting at
                            <strong>$5.99/mo</strong>
                          </small>
                        </div>
                      </div>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                </div>
              </div>
              <div class="col-12">
                <div class="menu-item-wrap py-0 p-md-3 p-lg-3">
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a class="title-with-icon-link" href="email-hosting.html">
                      <div class="d-flex align-items-center">
                        <div class="menu-item-icon pe-3">
                          <i
                            class="fas fa-envelope rounded-circle twitter-bg"
                          ></i>
                        </div>
                        <div class="media-body">
                          <span class="u-header__promo-title">
                            Email Hosting
                          </span>
                          <small class="u-header__promo-text">
                            First Starting at
                            <strong>$0.99/mo</strong>
                          </small>
                        </div>
                      </div>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a
                      class="title-with-icon-link"
                      href="windows-vps-hosting.html"
                    >
                      <div class="d-flex align-items-center">
                        <div class="menu-item-icon pe-3">
                          <i
                            class="fab fa-windows rounded-circle bg-success"
                          ></i>
                        </div>
                        <div class="media-body">
                          <span class="u-header__promo-title">
                            Windows VPS Hosting
                          </span>
                          <small class="u-header__promo-text">
                            Globally Starting at
                            <strong>$9.99/mo</strong>
                          </small>
                        </div>
                      </div>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a
                      class="title-with-icon-link"
                      href="dedicated-server-hosting.html"
                    >
                      <div class="d-flex align-items-center">
                        <div class="menu-item-icon pe-3">
                          <i
                            class="fas fa-database rounded-circle dribbble-bg"
                          ></i>
                        </div>
                        <div class="media-body">
                          <span class="u-header__promo-title">
                            Dedicated Server Hosting
                          </span>
                          <small class="u-header__promo-text">
                            Conveniently Starting at
                            <strong>$9.99/mo</strong>
                          </small>
                        </div>
                      </div>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                </div>
              </div>
            </div>
            <!--application hosting start-->
            <div class="application-hosting text-white">
              <span
                class="sub-menu-title text-lg-center text-md-center text-white mb-3"
              >
                Application For Hosting
              </span>
              <ul class="application-hosting-list">
                <li>
                  <a href="wp-hosting.html">
                    <img
                      src="assets/img/icons/wordpress-icon-color.svg"
                      alt="icon"
                    />
                    WordPress Hosting
                  </a>
                </li>
                <li>
                  <a href="joomla-hosting.html">
                    <img
                      src="assets/img/icons/joomla-icon-color.svg"
                      alt="icon"
                    />
                    Joomla Hosting
                  </a>
                </li>
                <li>
                  <a href="magento-hosting.html">
                    <img
                      src="assets/img/icons/magento-icon-color.svg"
                      alt="icon"
                    />
                    Magento Hosting
                  </a>
                </li>
                <li>
                  <a href="opencart-hosting.html">
                    <img
                      src="assets/img/icons/opencart-icon-color.svg"
                      alt="icon"
                    />
                    Opencart Hosting
                  </a>
                </li>
                <li>
                  <a href="prestashop-hosting.html">
                    <img
                      src="assets/img/icons/prestashop-icon-color.svg"
                      alt="icon"
                    />
                    Prestashop Hosting
                  </a>
                </li>
                <li>
                  <a href="drupal-hosting.html">
                    <img
                      src="assets/img/icons/drupal-icon-color.svg"
                      alt="icon"
                    />
                    Drupal Hosting
                  </a>
                </li>
              </ul>
            </div>
            <!--application hosting end-->
          </div>
        </li>
        <!--hosting item end-->

        <!--domain item start-->
        <li class="nav-item dropdown">
          <a
            class="nav-link dropdown-toggle"
            href="#"
            data-bs-toggle="dropdown"
          >
            Domain
          </a>
          <div class="dropdown-menu p-0">
            <div class="row g-0">
              <div class="">
                <div class="menu-item-wrap p-3">
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a class="title-with-icon-link" href="domain-checker.html">
                      <div class="d-flex align-items-center pb-1">
                        <i class="fas fa-globe me-2 color-primary"></i>
                        <span class="u-header__promo-title">
                          Domain Checker
                        </span>
                      </div>
                      <small class="u-header__promo-text">
                        Find the perfect domain for your business
                      </small>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a class="title-with-icon-link" href="domain-transfer.html">
                      <div class="d-flex align-items-center pb-1">
                        <i class="fas fa-exchange-alt me-2 color-accent"></i>
                        <span class="u-header__promo-title">
                          Domain Transfer
                        </span>
                      </div>
                      <small class="u-header__promo-text">
                        Transfer your domain easily
                      </small>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                  <!--menu title with subtitle and icon item start-->
                  <div class="title-with-icon-item">
                    <a
                      class="title-with-icon-link"
                      href="domain-registration.html"
                    >
                      <div class="d-flex align-items-center pb-1">
                        <i class="fas fa-copyright me-2 instagram-color"></i>
                        <span class="u-header__promo-title">
                          Domain Registration
                        </span>
                      </div>
                      <small class="u-header__promo-text">
                        Register your domain name for lifetime
                      </small>
                    </a>
                  </div>
                  <!--menu title with subtitle and icon item end-->
                </div>
              </div>
              <div class="gray-light-bg">
                <div class="menu-item-wrap p-4">
                  <h6>#1 Web Hosting Company</h6>
                  <ul class="list-unstyled tech-feature-list">
                    <li class="py-1">
                      <small>
                        <span
                          class="fas fa-check-circle text-success me-2"
                        ></span>
                        <strong>Flexible</strong>
                        Easy to Use Control Panel
                      </small>
                    </li>
                    <li class="py-1">
                      <small>
                        <span
                          class="fas fa-check-circle text-success me-2"
                        ></span>
                        <strong>99%</strong>
                        Uptime Guarantee
                      </small>
                    </li>
                    <li class="py-1">
                      <small>
                        <span
                          class="fas fa-check-circle text-success me-2"
                        ></span>
                        <strong>45-Day</strong>
                        Money-Back Guarantee
                      </small>
                    </li>
                    <li class="py-1">
                      <small>
                        <span
                          class="fas fa-check-circle text-success me-2"
                        ></span>
                        <strong>Free SSL</strong>
                        Certificate Included
                      </small>
                    </li>
                  </ul>
                  <a class="btn btn-tertiary btn-block mt-3" href="#">
                    Learn More
                    <span class="fas fa-angle-right ms-2"></span>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </li>
        <!--domain item end-->

        <!--affiliate item start-->
        <li class="nav-item">
          <a class="nav-link" href="affiliates.html">Affiliates</a>
        </li>
        <!--affiliate item end-->

        <!--company item start-->
        <li class="nav-item dropdown">
          <a
            class="nav-link dropdown-toggle"
            href="#"
            data-bs-toggle="dropdown"
            data-bs-auto-close="outside"
          >
            Company
          </a>
          <div class="dropdown-menu">
            <div class="row g-0">
              <div class="col-12">
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="contact-us.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/chat-mobile.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">Contact Us</span>
                        <small class="u-header__promo-text">
                          Face any problem contact with us
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="about-us.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/community.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">About Us</span>
                        <small class="u-header__promo-text">
                          We are leading hosting company
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="partners.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/partner.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">Our Partner</span>
                        <small class="u-header__promo-text">
                          We have trusted partners globally
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="network.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/network.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">Network</span>
                        <small class="u-header__promo-text">
                          Keep your data save and secure
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
                <div class="title-with-icon-item">
                  <a class="title-with-icon-link" href="blog-grid.html">
                    <div class="d-flex align-items-center">
                      <img
                        class="menu-titile-icon"
                        src="assets/img/blog.svg"
                        alt="SVG"
                      />
                      <div class="media-body">
                        <span class="u-header__promo-title">Company Blog</span>
                        <small class="u-header__promo-text">
                          Industry latest technology news & tips
                        </small>
                      </div>
                    </div>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </li>
        <!--company item end-->

        <!--button start-->
        <li
          class="nav-item header-nav-last-item d-flex align-items-center mt-3"
        >
          <a class="btn btn-tertiary animated-btn"
            href="https://whmcs.themetags.com/index.php?systpl=kohost&carttpl=themetags_cart" target="_blank">
            <span class="fa fa-user pe-2"></span>
            Client Area
          </a>
        </li>
        <!--button end-->
      </ul>
      <!--offcanvas menu list end-->
    </div>
  </div>
  <!--offcanvas menu end-->
</header>
<!--header section end-->

<div class="main">

    <!--hero section start-->
    <section class="hero-equal-height ptb-120 gradient-overlay bg-image" data-overlay="7">
        <div class="background-image-wraper" style="background: url('assets/img/hero-1.jpg')no-repeat center center / cover; opacity: 1;"></div>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-9 col-lg-8">
                    <div class="hero-content-left text-white text-center">
                        <h1 class="text-white">Search for Find Unique Domains!</h1>
                        <p class="lead">Up to 50% Off domain and hosting, Starting from $2.99/month, free SSL certificate, 24/7/365 support, money back guarantee.</p>

                        <?php 
                                $from       = !empty($_GET['from']) ? htmlspecialchars($_GET['from'], ENT_QUOTES, 'UTF-8') : '';
                                $domain     = !empty($_GET['domain']) ? htmlspecialchars($_GET['domain'], ENT_QUOTES, 'UTF-8') : '';
                                $domainType = !empty($_GET['domainType']) ? htmlspecialchars($_GET['domainType'], ENT_QUOTES, 'UTF-8') : '';

                                $domainName = "";
                                if($domain && $domainType) {
                                    $domainName = $domain . '.' . $domainType;
                                } else if($domain && !$domainType) {
                                    if(strpos($domain, ".") === false) {
                                        $domainName = $domain.'.com';
                                    } else {
                                        $domainName = $domain;
                                        $domain     = substr($domain, 0, strpos($domain, "."));
                                    }
                                }

                                include_once 'libs/whois/src/whois.main.php';

                                $whois = new Whois();
                                $whois->deep_whois = false;
                                $result = $whois->Lookup($domainName);

                                $domainInfo = !empty($result['regrinfo']['registered']) && $result['regrinfo']['registered'] == 'yes' ? true : false;
                            ?>

                        <form action="domain-search-result.php" method="GET" class="domain-transfer-form mt-3 w-75 d-block mx-auto">
                            <div class="input-group">
                                <input type="text" name="domain" id="domain" class="form-control" placeholder="<?php echo $domainName ? $domainName : 'yourdomainname.com'; ?>" value="<?php echo $domainName ? $domainName : ''; ?>" />
                                <div class="input-group-append">
                                    <button class="btn search-btn btn-brand-03 btn-hover d-flex align-items-center" type="submit">
                                        <span class="fas fa-globe mr-2"></span> Search
                                    </button>
                                </div>
                            </div>
                        </form>
                        <div class="domain-list-wrap text-center mt-4">
                            <ul class="list-inline domain-search-list">
                                <li class="list-inline-item border rounded"><a href="#"><img src="assets/img/com-w.png" alt="com" width="60" class="img-fluid"> <span>$8.99</span></a>
                                </li>
                                <li class="list-inline-item border rounded"><a href="#"><img src="assets/img/online-w.png" alt="com" width="60" class="img-fluid"> <span>$0.99</span></a>
                                </li>
                                <li class="list-inline-item border rounded"><a href="#"><img src="assets/img/net-w.png" alt="com" width="60" class="img-fluid"> <span>$4.99</span></a>
                                </li>
                                <li class="list-inline-item border rounded"><a href="#"><img src="assets/img/org-w.png" alt="com" width="60" class="img-fluid"> <span>$2.99</span></a>
                                </li>
                                <li class="list-inline-item border rounded"><a href="#"><img src="assets/img/store-w.png" alt="com" width="60" class="img-fluid"> <span>$0.99</span></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!--hero section end-->

    <!--domain search result section start-->
    <section class="domain-search-result-section gray-light-bg ptb-100">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-lg-3">
                    <div class="domain-extension-filter-wrap p-4 white-bg rounded">
                        <div class="domain-filter-title">
                          <h5 class="mb-0 d-flex">Filter Results <span
                                class="fas fa-angle-down ms-auto text-end"></span></h5>
                        </div>
                        <ul class="list-unstyled domain-filter-list mt-3">
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">Show All
                                </label>
                            </li>
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">.com
                                </label>
                            </li>
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">.net
                                </label>
                            </li>
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">.online
                                </label>
                            </li>
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">.org
                                </label>
                            </li>
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">.xyz
                                </label>
                            </li>
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">.store
                                </label>
                            </li>
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">.website
                                </label>
                            </li>
                            <li class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input" value="">.biz
                                </label>
                            </li>
                            <button type="submit" class="btn btn-block btn-outline-brand-01 btn-sm mt-3">Apply</button>
                        </ul>
                    </div>
                </div>
                <div class="col-md-12 col-lg-9">
                    <div class="content-with-sidebar">
                        <!--alert table start-->
                        <?php if($from != 'transfer' && empty($domainInfo)) {?>
                        <table class="table vps-hosting-pricing-table domain-search-result-table alert-table mb-5">
                            <tbody>
                            <tr class="vps-pricing-row">
                                <td>Domain <span class="color-primary"><?php echo $domainName; ?></span> is available!
                                    <br><small>Get this domain now </small></td>
                                <td>
                                    <p>
                                        <span class="rate">$3.95<span>/month</span></span>
                                        <span class="pricing-onsale">On sale - <span class="badge color-3 color-3-bg">Save 30%</span></span>
                                    </p>
                                </td>
                                <td>
                                    <a href="http://whmcs.themetags.com/cart.php?systpl=kohost&a=add&domain=register&query=<?php echo $domainName; ?>" class="btn btn-brand-01 btn-sm">Add to Cart</a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <?php } else if($from == 'transfer' && !empty($domainInfo)) {?>
                        <table class="table vps-hosting-pricing-table domain-search-result-table alert-table mb-5">
                            <tbody>
                            <tr class="vps-pricing-row">
                                <td>Domain <span class="color-primary"><?php echo $domainName; ?></span> is ready to transfer!
                                    <br><small>Transfer your domain now </small></td>
                                <td>
                                    <p>
                                        <span class="rate">$3.95<span>/month</span></span>
                                        <span class="pricing-onsale">On sale - <span class="badge color-3 color-3-bg">Save 30%</span></span>
                                    </p>
                                </td>
                                <td>
                                    <a href="http://whmcs.themetags.com/cart.php?systpl=kohost&a=add&domain=transfer&query=<?php echo $domainName; ?>" class="btn btn-brand-01 btn-sm">Add to Cart</a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <?php } else if($from != 'transfer' && !empty($domainInfo)){?>
                        <div class="row">
                            <div class="col-12 pb-3">
                                <div class="alert alert-danger">Domain(<?php echo $domainName; ?>) is not available. </div>
                            </div>
                        </div>
                        <?php } else if($from == 'transfer' && empty($domainInfo)){?>
                        <div class="row">
                            <div class="col-12 pb-3">
                                <div class="alert alert-danger">Domain(<?php echo $domainName; ?>) is not registered. </div>
                            </div>
                        </div>
                        <?php } ?>
                        <!--alert table end-->
                        <h4 class="text-center">More domain options</h4>
                        <table class="table vps-hosting-pricing-table domain-search-result-table">
                            <tbody>
                            <tr class="vps-pricing-row">
                                <td data-value="Available"><?php echo $domain ? $domain : 'kohost'; ?><span class="color-primary">.com</span></td>
                                <td data-value="Price">
                                    <p>
                                        <span class="rate">$3.95<span>/month</span></span>
                                        <span class="pricing-onsale">On sale - <span class="badge color-3 color-3-bg">Save 30%</span></span>
                                    </p>
                                </td>
                                <td>
                                    <a href="" class="btn btn-brand-01 btn-sm">Add to Cart</a>
                                </td>
                            </tr>
                            <tr class="vps-pricing-row">
                                <td data-value="Available"><?php echo $domain ? $domain : 'kohost'; ?><span class="color-primary">.net</span></td>
                                <td data-value="Price">
                                    <p>
                                        <span class="rate">$8.95<span>/month</span></span>
                                        <span class="pricing-onsale">On sale - <span class="badge color-1 color-1-bg">Save 50%</span></span>
                                    </p>
                                </td>
                                <td>
                                    <a href="" class="btn btn-brand-01 btn-sm">Add to Cart</a>
                                </td>
                            </tr>
                            <tr class="vps-pricing-row">
                                <td data-value="Available"><?php echo $domain ? $domain : 'kohost'; ?><span class="color-primary">.org</span></td>
                                <td data-value="Price">
                                    <p>
                                        <span class="rate">$12.95<span>/month</span></span>
                                        <span class="pricing-onsale">On sale - <span class="badge color-3 color-3-bg">Save 10%</span></span>
                                    </p>
                                </td>
                                <td>
                                    <a href="" class="btn btn-brand-01 btn-sm">Add to Cart</a>
                                </td>
                            </tr>
                            <tr class="vps-pricing-row">
                                <td data-value="Available"><?php echo $domain ? $domain : 'kohost'; ?><span class="color-primary">.info</span></td>
                                <td data-value="Price">
                                    <p><span class="rate">$15.95<span>/month</span></span><span class="pricing-onsale">On sale - <span
                                            class="badge color-3 color-3-bg">Save 30%</span></span></p>
                                </td>
                                <td>
                                    <a href="" class="btn btn-brand-01 btn-sm">Add to Cart</a>
                                </td>
                            </tr>
                            <tr class="vps-pricing-row">
                                <td data-value="Available"><?php echo $domain ? $domain : 'kohost'; ?><span class="color-primary">.store</span></td>
                                <td data-value="Price">
                                    <p><span class="rate">$23.95<span>/month</span></span><span class="pricing-onsale">On sale - <span
                                            class="badge color-5 color-5-bg">Save 40%</span></span></p>
                                </td>
                                <td>
                                    <a href="" class="btn btn-brand-01 btn-sm">Add to Cart</a>
                                </td>
                            </tr>
                            <tr class="vps-pricing-row">
                                <td data-value="Available"><?php echo $domain ? $domain : 'kohost'; ?><span class="color-primary">.online</span></td>
                                <td data-value="Price">
                                    <p><span class="rate">$29.95<span>/month</span></span><span class="pricing-onsale">On sale - <span
                                            class="badge color-3 color-3-bg">Save 10%</span></span></p>
                                </td>
                                <td>
                                    <a href="" class="btn btn-brand-01 btn-sm">Add to Cart</a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--domain search result section end-->

    <!--popular domain list section start-->
    <section class="feature-tab-section ptb-100 ">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-6 col-12 order-lg-last">
                    <div class="image-box fadein text-xl-right text-center">
                        <img src="assets/img/network-1.jpg" alt="wp-hosting"
                             class="img-fluid rounded"/>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-12 order-xl-first">
                    <h2>Advanced Search to Make your Life Fester and Easier</h2>
                    <p class="lead">Progressively matrix mission-critical core competencies without magnetic
                        paradigms.</p>
                    <div class="row pt-2">
                        <div class="col-12">
                            <h5>Multi-layered security</h5>
                            <p>Continually empower goal-oriented niche markets whereas interoperable outsourcing. Assertively incubate standardized methods of empowerment </p>
                        </div>
                        <div class="col-12">
                            <h5>Green-friendly hosting</h5>
                            <p>Monotonectally negotiate multifunctional applications whereas unique niche markets. Continually recaptiualize open-source catalysts for change whereas adaptive content.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row justify-content-between mt-5">
                <div class="col-xl-6 col-lg-6 col-12 order-lg-last">
                    <div class="image-box fadein text-xl-right text-center">
                        <img src="assets/img/network-2.jpg" alt="wp-hosting" class="img-fluid rounded"/>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-12 order-xl-last">
                    <h2>Fast connectivity & low latency</h2>
                    <p class="lead">Efficiently reintermediate long-term high-impact channels without equity
                        invested technology.</p>
                    <div class="row pt-2">
                        <div class="col-12">
                            <h5>Exclusive Features</h5>
                            <p>Globally seize functional products rather than compelling supply chains capital before frictionless quality vectors. Holisticly envisioneer worldwide niche markets for efficient services.</p>
                        </div>
                        <div class="col-12">
                            <h5>Ultra-Fast Network</h5>
                            <p>Dramatically aggregate granular resources vis-a-vis process-centric process  deliver enterprise-wide scenarios improvements. Quickly target compelling e-services after cross functional schemas. </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--popular domain list section end-->

    <!--domain name block start-->
    <section class="ptb-60 primary-bg">
        <div class="container">
            <div class="row align-items-center justify-content-between">
                <div class="col-md-7 col-lg-6">
                    <div class="cta-content-wrap text-white">
                        <h2 class="text-white">أفضل استضافة سحابية <br> مع خدمة موثوقة</h2>
                        <p>ابتكار معايير عالية في المنهجيات بشكل موضوعي في مقابل الحفاظ على عملية متعددة التخصصات بشكل استباقي تبسيط المعلومات المهمة للمهمة عبر متطلبات الجودة. </p>
                    </div>
                    <div class="action-btns mt-4">
                        <a href="#" class="btn btn-tertiary"> Get start now</a>
                    </div>
                </div>
                <div class="col-md-5 col-lg-4">
                    <div class="cta-img-wrap text-center">
                        <img src="assets/img/server-room.svg" class="img-fluid" alt="server room">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--domain name block end-->

    <!--faq new style start-->
    <section id="faq" class="ptb-100 ">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-9 col-lg-6">
                    <div class="section-heading text-center mb-5">
                        <h2>Frequently Asked Queries</h2>
                        <p>Efficiently productivate reliable paradigms before ubiquitous models. Continually utilize frictionless expertise whereas tactical relationships. Still have questions? Contact us</p>
                    </div>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-md-12 col-lg-12">
                    <div class="accordion faq-wrap" id="accordionExample">
    
                        <!-- Item -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingOne">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">If I have a WordPress site hosted somewhere else, can I move it to Kohost?</button>
                            </h2>
                            <div class="accordion-collapse collapse show" id="collapseOne" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body">Credibly maximize open-source methodologies via sustainable synergy. Dynamically predominate diverse architectures via user-centric technologies. Credibly enable clicks-and-mortar services whereas extensive services. Proactively integrate orthogonal technologies whereas seamless networks. Dynamically transition intermandated communities via premier mindshare.</div>
                            </div>
                        </div>
    
                        <!-- Item -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingTwo">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">What’s the difference between WordPress Hosting and shared Web Hosting?</button>
                            </h2>
                            <div class="accordion-collapse collapse" id="collapseTwo" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                <div class="accordion-body">Energistically conceptualize visionary results and premier best practices. Enthusiastically innovate leveraged testing procedures rather than progressive experiences. Uniquely incubate bricks-and-clicks potentialities and process-centric "outside the box" thinking. Dramatically recaptiualize magnetic services rather than fully tested products. Appropriately productize innovative convergence before superior niches.</div>
                            </div>
                        </div>
    
                        <!-- Item -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingThree">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">How do I know what WordPress Hosting plan is best for me?</button>
                            </h2>
                            <div class="accordion-collapse collapse" id="collapseThree" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                <div class="accordion-body">Compellingly utilize go forward portals with go forward manufactured products. Continually evolve clicks-and-mortar web services and just in time quality vectors. Holisticly envisioneer unique technology whereas equity invested networks. Dynamically target reliable services without multifunctional convergence. Seamlessly visualize resource-leveling vortals after prospective partnerships.</div>
                            </div>
                        </div>
    
                        <!-- Item -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingFour">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseFour" aria-expanded="false"
                                        aria-controls="collapseFour">Is email included with WordPress Hosting?</button>
                            </h2>
                            <div class="accordion-collapse collapse" id="collapseFour" aria-labelledby="headingFour"
                                 data-bs-parent="#accordionExample">
                                <div class="accordion-body">Professionally integrate optimal initiatives for progressive "outside the box" thinking. Intrinsicly drive real-time synergy with bleeding-edge growth strategies. Synergistically productize mission-critical portals vis-a-vis interactive customer service. Synergistically predominate B2B outsourcing for magnetic synergy. Energistically optimize synergistic expertise whereas premier results.</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>    <!--faq new style end-->


</div>

<!--footer section start-->
<footer
  class="footer-1 ptb-60 gradient-bg"
>
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-lg-4 mb-4 mb-md-4 mb-sm-4 mb-lg-0">
        <a href="#" class="d-block">
          <img
            src="assets/img/logo-white.png"
            alt="logo"
            class="img-fluid"
          />
        </a>
        <br />
        <p>
          Dynamically re-engineer high standards in functiona with alternative
          paradigms. Conveniently monetize resource maximizing initiatives.
        </p>
        <ul
          class="list-inline social-list-default background-color social-hover-2 mt-2"
        >
          <li class="list-inline-item">
            <a class="twitter" href="#"><i class="fab fa-twitter"></i></a>
          </li>
          <li class="list-inline-item">
            <a class="youtube" href="#"><i class="fab fa-youtube"></i></a>
          </li>
          <li class="list-inline-item">
            <a class="linkedin" href="#"><i class="fab fa-linkedin-in"></i></a>
          </li>
          <li class="list-inline-item">
            <a class="dribbble" href="#"><i class="fab fa-dribbble"></i></a>
          </li>
        </ul>
      </div>
      <div class="col-md-12 col-lg-8">
        <div class="row mt-0">
          <div class="col-sm-6 col-md-3 col-lg-3 mb-4 mb-sm-4 mb-md-0 mb-lg-0">
            <h6 class="font-weight-normal">Resources</h6>
            <ul>
              <li>
                <a href="#">Help</a>
              </li>
              <li>
                <a href="#">Events</a>
              </li>
              <li>
                <a href="#">Live sessions</a>
              </li>
              <li>
                <a href="#">Open source</a>
              </li>
              <li>
                <a href="#">Documentation</a>
              </li>
            </ul>
          </div>
          <div class="col-sm-6 col-md-3 col-lg-3 mb-4 mb-sm-4 mb-md-0 mb-lg-0">
            <h6 class="font-weight-normal">Products</h6>
            <ul>
              <li>
                <a href="#">Pricing</a>
              </li>
              <li>
                <a href="#">Navigation</a>
              </li>
              <li>
                <a href="#">AI Studio</a>
              </li>
              <li>
                <a href="#">Page Speed </a>
              </li>
              <li>
                <a href="#">Performance</a>
              </li>
            </ul>
          </div>
          <div class="col-sm-6 col-md-3 col-lg-3 mb-4 mb-sm-4 mb-md-0 mb-lg-0">
            <h6 class="font-weight-normal">Company</h6>
            <ul>
              <li>
                <a href="#">About Us</a>
              </li>
              <li>
                <a href="#">Careers</a>
              </li>
              <li>
                <a href="#">Customers</a>
              </li>
              <li>
                <a href="#">Community</a>
              </li>
              <li>
                <a href="#">Our Team</a>
              </li>
            </ul>
          </div>
          <div class="col-sm-6 col-md-3 col-lg-3">
            <h6 class="font-weight-normal">Support</h6>
            <ul>
              <li>
                <a href="#">FAQ</a>
              </li>
              <li>
                <a href="#">Sells</a>
              </li>
              <li>
                <a href="#">Contact Support</a>
              </li>
              <li>
                <a href="#">Network Status</a>
              </li>
              <li>
                <a href="#">Product Services</a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--end of container-->
</footer>

<!--footer bottom copyright start-->
<div class="footer-bottom py-3 gray-light-bg">
  <div class="container">
    <div class="row">
      <div class="col-md-6 col-lg-7">
        <div class="copyright-wrap small-text">
          <p class="mb-0">
            &copy; ThemeTags Design Agency, All rights reserved
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-5">
        <div class="terms-policy-wrap text-lg-end text-md-end text-start">
          <ul class="list-inline">
            <li class="list-inline-item">
              <a class="small-text" href="terms-condition.html"
                >Terms & Condition</a
              >
            </li>
            <li class="list-inline-item">
              <a class="small-text" href="privacy-policy.html"
                >Privacy Policy</a
              >
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>
<!--footer bottom copyright end-->
<!--footer section end-->
 <!--scroll bottom to top button start-->
<div class="scroll-top scroll-to-target primary-bg text-white" data-target="html">
    <span class="fas fa-hand-point-up"></span>
</div>
<!--scroll bottom to top button end-->

    <!--build:js-->
    <script src="assets/js/vendors/jquery-3.6.0.min.js"></script>
    <script src="assets/js/vendors/bootstrap.bundle.min.js"></script>
    <script src="assets/js/vendors/bootstrap-slider.min.js"></script>
    <script src="assets/js/vendors/swiper-bundle.min.js"></script>
    <script src="assets/js/vendors/magnific-popup.min.js"></script>
    <script src="assets/js/vendors/validator.min.js"></script>
    <script src="assets/js/vendors/hs.megamenu.js"></script>
    <script src="assets/js/app.js" ></script>
    <!--endbuild-->
  </body>
</html>
